package com.ejianc.business.purchase.service.impl;

import com.ejianc.business.purchase.bean.SchemeChangeEntity;
import com.ejianc.business.purchase.bean.SchemeEntity;
import com.ejianc.business.purchase.bean.SchemeHistoryEntity;
import com.ejianc.business.purchase.cons.CommonConstant;
import com.ejianc.business.purchase.service.ISchemeChangeService;
import com.ejianc.business.purchase.service.ISchemeHistoryService;
import com.ejianc.business.purchase.service.ISchemeService;
import com.ejianc.business.purchase.utils.EntityUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("schemeChange") 
public class SchemeChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IAttachmentApi attachmentApi;

	@Autowired
	private ISchemeChangeService service;

	@Autowired
	private ISchemeService billService;

	@Autowired
	private ISchemeHistoryService historyService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("--------------变更审批通过，处理业务");
		SchemeChangeEntity change = service.selectById(billId);

		SchemeEntity bill = billService.selectById(change.getSourceId());

		logger.info("--------------同步原单据到历史表");
		SchemeHistoryEntity history = BeanMapper.map(bill, SchemeHistoryEntity.class);
		Long historyId = IdWorker.getId();
		history = EntityUtil.clearInvalidEntity(history, SchemeHistoryEntity.class);
		history.setId(historyId);

		historyService.saveOrUpdate(history, false);

		// 将原单据附件复制到历史记录
		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(bill.getId()), "EJCBT202504000026", "attachMgr",
				String.valueOf(history.getId()), "EJCBT202504000026", "attachMgr");
		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(bill.getId()), "EJCBT202504000026", "file",
				String.valueOf(history.getId()), "EJCBT202504000026", "file");

		logger.info("--------------同步变更到原单据");
		bill.setChangeStatus(CommonConstant.CHANGE_OVER);
		bill.setChangeVersion(change.getChangeVersion());
		bill.setChangeReason(change.getChangeReason());
		bill.setChangeDate(change.getChangeDate());
		// 表头变更字段需回写到原单据
		bill.setBillDate(change.getBillDate());
		bill.setEmployeeId(change.getEmployeeId());
		bill.setEmployeeName(change.getEmployeeName());
		bill.setDeptId(change.getDeptId());
		bill.setDeptName(change.getDeptName());
		bill.setIncomeMny(change.getIncomeMny());
		bill.setPurchaseMny(change.getPurchaseMny());
		bill.setSurplusMny(change.getSurplusMny());

		// 全量替换子表
		EntityUtil.syncDetail(bill, change, "sourceId");
		billService.saveOrUpdate(bill, false);

		logger.info("--------------处理变更附件");
		// 变更附件复制到原单据，同步删除附件
		attachmentApi.copyFiles(String.valueOf(billId), billTypeCode, "attachMgr",
				String.valueOf(bill.getId()), "EJCBT202504000026", "attachMgr", true);
		attachmentApi.copyFiles(String.valueOf(billId), billTypeCode, "file",
				String.valueOf(bill.getId()), "EJCBT202504000026", "file", true);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
