package com.ejianc.business.purchase.service.impl;

import com.ejianc.business.purchase.bean.SchemeEntity;
import com.ejianc.business.purchase.service.ISchemeService;
import com.ejianc.business.purchase.utils.EntityUtil;
import com.ejianc.business.purchase.vo.SchemeChangeDetailVO;
import com.ejianc.business.purchase.vo.SchemeChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchase.mapper.SchemeChangeMapper;
import com.ejianc.business.purchase.bean.SchemeChangeEntity;
import com.ejianc.business.purchase.service.ISchemeChangeService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 采购策划-变更
 * 
 * @author generator
 * 
 */
@Service("schemeChangeService")
public class SchemeChangeServiceImpl extends BaseServiceImpl<SchemeChangeMapper, SchemeChangeEntity> implements ISchemeChangeService{

    @Autowired
    private ISchemeService billService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public SchemeChangeVO queryDetailChange(Long id) {
        SchemeEntity entity = billService.selectById(id);

        // 校验同一个项目只能存在一个自由态或审批中的单据
        this.validateProjectId(entity.getId(), null, "重复新增");

        SchemeChangeVO vo = BeanMapper.map(entity, SchemeChangeVO.class);
        for (SchemeChangeDetailVO detail : vo.getDetailList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
            detail.setId(IdWorker.getId());
        }
        vo.setSourceId(vo.getId());
        vo.setBillState(null);
        vo.setChangeReason(null);
        vo.setBillCode(null);
        vo.setChangeVersion(vo.getChangeVersion() == null ? 1 : vo.getChangeVersion() + 1);
        vo.setChangeDate(new Date());
        EntityUtil.clearInvalidData(vo);

        // 拷贝附件到变更单
        vo.setId(IdWorker.getId());
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "EJCBT202504000026", "attachMgr",
                String.valueOf(vo.getId()), "EJCBT202504000027", "attachMgr");
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "EJCBT202504000026", "file",
                String.valueOf(vo.getId()), "EJCBT202504000027", "file");
        return vo;
    }

    @Override
    public List<SchemeChangeVO> queryChangeHistory(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("sourceId", new Parameter(QueryParam.EQ, id));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getOrderMap().put("changeVersion", QueryParam.DESC);
        List<SchemeChangeEntity> list = super.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }
        List<SchemeChangeVO> result = BeanMapper.mapList(list, SchemeChangeVO.class);
        for (SchemeChangeVO vo : result) {
            String historyBillCode = vo.getBillCode() + "-" + (vo.getChangeVersion() - 1);
            vo.setHistoryBillCode(historyBillCode);
        }
        return result;
    }

    @Override
    public String validateProjectId(Long sourceId, Long id, String operation) {
        // 只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, sourceId));
        if(id != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<SchemeChangeEntity> list = super.queryList(queryParam, false);
        List<SchemeChangeEntity> freeList = list.stream().filter(x->1 !=x.getBillState() && 3 !=x.getBillState()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(freeList)) {
            throw new BusinessException("该采购策划存在非生效态的变更单，不能" + operation + "!");
        }
        return "校验成功！";
    }
}
