package com.ejianc.business.purchase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.purchase.bean.SubPlanEntity;
import com.ejianc.business.purchase.service.ISubPlanService;
import com.ejianc.business.purchase.utils.DateUtil;
import com.ejianc.business.sync.bean.SyncRecordsEntity;
import com.ejianc.business.sync.consts.HTConstants;
import com.ejianc.business.sync.vo.FileDto;
import com.ejianc.business.sync.vo.PlanDetailDto;
import com.ejianc.business.sync.vo.PlanDto;
import com.ejianc.business.sync.vo.SyncRecordsVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.mq.common.MqMessage;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("subPlan") 
public class SubPlanBpmServiceImpl implements ICommonBusinessService {

	public static final String SYNC_RECORD_QUEUE = "purchase_record_queue";

	@Value("${common.env.base-host}")
	private String baseHost;

	@Value("${spring.cloud.config.profile}")
	private String profile;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private RabbitTemplate rabbitTemplate;

	@Autowired
	private IAttachmentApi attachmentApi;

	@Autowired
	private ISubPlanService service;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SubPlanEntity entity = service.selectById(billId);
//		// 是否签订合同为否不推送集采平台
//		if(new Integer(1).equals(entity.getSignState())){
//			// 推送MQ汇总
//			this.sendMq(entity);
//		}
		// 推送MQ汇总
		this.sendMq(entity);
		return CommonResponse.success();
	}

	/**
	 * 消息发送MQ队列成功
	 * @param entity
	 * @return
	 */
	public String sendMq(SubPlanEntity entity) {
		SyncRecordsEntity record = new SyncRecordsEntity();
		// 部分信息因为mq无法获取，提前赋值
		record.setOperatorId(InvocationInfoProxy.getUserid());
		record.setOperatorName(sessionManager.getUserContext().getUserName());
		record.setPushDate(new Date());
		record.setTenantId(InvocationInfoProxy.getTenantid());
		record.setCreateUserCode(InvocationInfoProxy.getUsercode());
		record.setCreateTime(new Date());

		// 业务信息
		record.setHandleType(SyncRecordsVO.SYNC_TYPE_PLAN);
		String url = HTConstants.PLAN_REQ_HOST + HTConstants.HT_PLAN_SYNC_URL;
		record.setUrl(url);
		// 转换VO
		PlanDto vo = this.transferDto(entity);
		record.setData(JSONObject.toJSONString(vo));

		MqMessage mqMessage = new MqMessage();
		mqMessage.setBody(record);
		rabbitTemplate.convertAndSend(SYNC_RECORD_QUEUE+"_"+profile, mqMessage);
		return "消息发送MQ队列成功！";
	}

	/**
	 *
	 * @param entity
	 * @return
	 */
	private PlanDto transferDto(SubPlanEntity entity) {
		PlanDto vo = new PlanDto();
		vo.setOutPlanNo(HTConstants.HT_UNIT_CODE + "_" + entity.getId());
		vo.setTitle(entity.getPlanName());
//		BigDecimal planAtm = entity.getDetailList().stream().map(x->x.getMoney()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
//		vo.setPlanAtm(planAtm);
		vo.setPlanAtm(entity.getSubjectMny());
		vo.setStatus("40");
		vo.setRemark(entity.getMemo());
		vo.setAttachment(null);
		vo.setCreateDate(DateUtil.formatDate(entity.getCreateDate(), "yyyyMMddHHmmss"));
		vo.setCreateUser(HTConstants.HT_INVENTED_ACCOUNT);
		vo.setCreateUserId(HTConstants.HT_INVENTED_EMP_ID);
		vo.setCreateUserName(HTConstants.HT_INVENTED_EMP_NAME);
		vo.setCreateDeptCode(HTConstants.HT_INVENTED_DEPT_CODE);
		vo.setCreateDeptName(HTConstants.HT_INVENTED_DEPT_NAME);
		vo.setCreateOrgCode(HTConstants.HT_INVENTED_ORG_CODE);
		vo.setCreateOrgName(HTConstants.HT_INVENTED_ORG_NAME);
		vo.setSysCode(HTConstants.SYS_CODE);
		vo.setCreatePlateCode(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_CODE);
		vo.setCreatePlateName(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_NAME);

		//查询单据附件信息并下载
		CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
		if (fileResp.isSuccess()) {
			List<FileDto> attachment = new ArrayList<>();
			for(AttachmentVO file : fileResp.getData()){
				FileDto dto = new FileDto();
				dto.setFileName(file.getFileName());
				dto.setFileType(FileUtils.getFileExt(file.getFileName(), false));
				dto.setFileSize(String.valueOf(file.getFileSize()));
				dto.setDownloadUrl(baseHost + "ejc-file-web/attachment/filePreview?fileId=" + file.getId());
				attachment.add(dto);
			}
			vo.setAttachment(attachment);
		}

//		List<Long> typeIds = entity.getDetailList().stream().map(x->x.getMaterialTypeId()).distinct().collect(Collectors.toList());
//		Map<Long, MaterialCategoryVO> typeMap = new HashMap<>();
//		if(CollectionUtils.isNotEmpty(typeIds)){
//			CommonResponse<List<MaterialCategoryVO>> resp = materialApi.queryCategoryListByIds(typeIds);
//			if(!resp.isSuccess()){
//				throw new BusinessException(resp.getMsg());
//			}
//			typeMap = resp.getData().stream().collect(Collectors.toMap(x->x.getId(), x->x));
//		}
//		List<Long> materialIds = entity.getDetailList().stream().map(x->x.getMaterialId()).distinct().collect(Collectors.toList());
//		Map<Long, MaterialVO> materialMap = new HashMap<>();
//		if(CollectionUtils.isNotEmpty(materialIds)){
//			CommonResponse<List<MaterialVO>> resp = materialApi.queryMaterialItemByIds(materialIds);
//			if(!resp.isSuccess()){
//				throw new BusinessException(resp.getMsg());
//			}
//			materialMap = resp.getData().stream().collect(Collectors.toMap(x->x.getId(), x->x));
//		}
//		List<String> userIds = entity.getDetailList().stream().filter(x->null != x.getBuyerId()).map(x->String.valueOf(x.getBuyerId())).distinct().collect(Collectors.toList());
//		Map<Long, UserVO> userMap = new HashMap<>();
//		if(CollectionUtils.isNotEmpty(userIds)){
//			CommonResponse<List<UserVO>> resp = userApi.queryListByIds(userIds.toArray(new String[0]));
//			if(!resp.isSuccess()){
//				throw new BusinessException(resp.getMsg());
//			}
//			userMap = resp.getData().stream().collect(Collectors.toMap(x->x.getId(), x->x));
//		}
//
//		List<PlanDetailDto> detailList = new ArrayList<>();
//		for(SubPlanDetailEntity data : entity.getDetailList()){
//			PlanDetailDto detail = new PlanDetailDto();
//			detail.setOutPlanLineNo(HTConstants.HT_UNIT_CODE + "_" + data.getId());
//			detail.setOutPlanNo(vo.getOutPlanNo());
//			detail.setTitle(vo.getTitle());
//			detail.setPlanType("3".equals(data.getPlanType()) ? "3" : null);
//			if(typeMap.containsKey(data.getMaterialTypeId())){
//				detail.setCategory(typeMap.get(data.getMaterialTypeId()).getCode());
//			}
//			detail.setCategoryName(data.getMaterialTypeName());
//			detail.setItemId(data.getMaterialCode());
//			detail.setItemName(data.getMaterialName());
//			if(materialMap.containsKey(data.getMaterialId())){
//				MaterialVO material = materialMap.get(data.getMaterialId());
//				detail.setItemDesc(material.getDef8());
//				detail.setItemDescMore(material.getDef7());
//				detail.setItemUom(material.getDef9());
//			}
//			detail.setQty(ComputeUtil.scale(data.getNum(), 4));
//			detail.setCurrencyCode("CNY");
//			detail.setBudgetAtm(ComputeUtil.scale(data.getMoney(), 4));
//			detail.setBudgetPrice(ComputeUtil.scale(data.getPrice(), 8));
//			detail.setPurcType(data.getPurcType());
//			detail.setPurcSubtype(data.getPurcSubtype());
//			detail.setRequiredDate(DateUtils.transformationDate(data.getRequiredDate(), "yyyyMMdd"));
//			detail.setEndDate(DateUtils.transformationDate(data.getEndDate(), "yyyyMMdd"));
//			detail.setStartDate(DateUtils.transformationDate(data.getStartDate(), "yyyyMMdd"));
//			detail.setIsConstructionProject(data.getIsConstructionProject());
//			detail.setProjectNo(entity.getProjectCode());
//			detail.setProjectName(entity.getProjectName());
//			detail.setTaxMark(data.getTaxMark());
//			detail.setPartUsed(data.getConstruction());
//			detail.setUrgencyType(String.valueOf(entity.getUrgentState()));
//			detail.setUrgentReason(data.getUrgentReason());
//			detail.setIsPiecemeal(String.valueOf(entity.getSporadicState()));
//			detail.setTprnd01Status("40");
//			detail.setFocusPurOrgForm("10");
//			detail.setRemark(data.getMemo());
//			if(userMap.containsKey(data.getBuyerId())){
//				UserVO user = userMap.get(data.getBuyerId());
//				detail.setReqUser(user.getUserCode());
//				detail.setReqName(user.getUserName());
//			}
//			detail.setApplyDeptId(HTConstants.HT_INVENTED_DEPT_CODE);
//			detail.setApplyDeptName(HTConstants.HT_INVENTED_DEPT_NAME);
//			detail.setApplyOrgId(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_CODE);
//			detail.setApplyOrgName(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_NAME);
//			detail.setCreateUserId(HTConstants.HT_INVENTED_EMP_ID);
//			detail.setCreateUser(HTConstants.HT_INVENTED_ACCOUNT);
//			detail.setCreateUserName(HTConstants.HT_INVENTED_EMP_NAME);
//			detail.setCreateOrgCode(HTConstants.HT_INVENTED_ORG_CODE);
//			detail.setCreateOrgName(HTConstants.HT_INVENTED_ORG_NAME);
//			detail.setCreateDate(DateUtils.transformationDate(data.getCreateTime(), "yyyyMMddHHmmss"));
//			detail.setCreateDeptCode(HTConstants.HT_INVENTED_DEPT_CODE);
//			detail.setCreateDeptName(HTConstants.HT_INVENTED_DEPT_NAME);
//			detail.setActualDemandPlanOrgCode(entity.getOrgCode());
//			detail.setActualDemandPlanOrgName(entity.getOrgName());
//			detail.setActualDemandPlanDeptCode(entity.getProjectCode());
//			detail.setActualDemandPlanDeptName(entity.getProjectName());
//			detail.setActualDemandPlanPlannerCode(String.valueOf(entity.getEmployeeId()));
//			detail.setActualDemandPlanPlanner(entity.getEmployeeName());
//			detail.setSysCode(HTConstants.SYS_CODE);
//			detail.setCreatePlateCode(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_CODE);
//			detail.setCreatePlateName(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_NAME);
//
//			detailList.add(detail);
//		}
//		vo.setPlanDetailList(detailList);
		return vo;
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
