/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchase.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import com.ejianc.framework.core.util.JsonUtils;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static Logger logger = LoggerFactory.getLogger(JSONUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static <T> T map(String json, Class<T> cls) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        Object obj = null;
        try {
            MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            obj = MAPPER.readValue(json, cls);
        }
        catch (Exception e) {
            if (!JsonUtils.isJson((String)json)) {
                logger.error("content is not json: " + json + " --> " + e.getMessage());
            }
            logger.error("Convert to object failure: " + json, (Throwable)e);
        }
        return (T)obj;
    }

    public static <T> List<T> json2ListMapper(String json, Class<T> cls) {
        JSONArray array = JSONArray.parseArray((String)json);
        ArrayList<T> list = new ArrayList<T>();
        for (Object obj : array) {
            T vo = JSONUtils.map(JSONObject.toJSONString(obj), cls);
            if (null == vo) continue;
            list.add(vo);
        }
        return list;
    }

    public static <T> List<T> mapList(JSONArray array, Class<T> cls) {
        ArrayList<T> list = new ArrayList<T>();
        for (Object obj : array) {
            T vo = JSONUtils.map(JSONObject.toJSONString(obj), cls);
            if (null == vo) continue;
            list.add(vo);
        }
        return list;
    }

    public static <S, T> List<T> mapList(Iterable<S> sourceList, Class<T> cls) {
        ArrayList<T> list = new ArrayList<T>();
        for (S source : sourceList) {
            if (source == null) continue;
            T vo = JSONUtils.map(JSONObject.toJSONString(source), cls);
            list.add(vo);
        }
        return list;
    }

    public static <T> List<T> json2List(String json, TypeReference<T> type) {
        JSONArray array = JSONArray.parseArray((String)json);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : array) {
            JSONUtils.lineToHump(obj);
            Object vo = JSON.parseObject((String)JSONObject.toJSONString(obj), type, (Feature[])new Feature[0]);
            if (null == vo) continue;
            list.add(vo);
        }
        return list;
    }

    public static <T> List<T> json2List(String jsonArray, Class<T> cls) {
        if (StringUtils.isEmpty((CharSequence)jsonArray)) {
            return new ArrayList();
        }
        JSONArray array = JSONArray.parseArray((String)jsonArray);
        array.stream().forEach(x -> JSONUtils.lineToHump(x));
        List list = array.toJavaList(cls);
        return list;
    }

    public static void lineToHump(Object obj) {
        block3: {
            String[] keyArray;
            block2: {
                if (!(obj instanceof JSONArray)) break block2;
                JSONArray jsonArray = (JSONArray)obj;
                for (Object json : jsonArray) {
                    JSONUtils.lineToHump(json);
                }
                break block3;
            }
            if (!(obj instanceof JSONObject)) break block3;
            JSONObject json = (JSONObject)obj;
            Set keySet = json.keySet();
            for (String key : keyArray = keySet.toArray(new String[keySet.size()])) {
                Object value = json.get((Object)key);
                String[] keyStrs = key.split("_");
                if (keyStrs.length <= 1) continue;
                String newKey = CamelAndUnderLineConverter.lineToHump((String)key);
                json.remove((Object)key);
                json.put(newKey, value);
            }
        }
    }
}

