package com.ejianc.business.purchasingmanagement.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 采购运输信息
 * 
 * @author generator
 * 
 */
public class PurchasetransportationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long materialplanId; // 定料计划主键
    private Long supplierinfoId; // 供应商基本档案主键
    private String supplierinfoName; // 供应商基本档案名称
    private Long materialId; // 原材类主键
    private String materialName; // 原材类名称
    private Long shippersId; // 运输商主键
    private String shippersName; // 运输商名称
    private BigDecimal deliveryQuantity; // 发货数量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date deliveryTime; // 发货时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Integer shippingMethod; // 运输方式
    private BigDecimal distance; // 运距
    private BigDecimal unitPrice; // 运输单价
    private Long receivingaddressId;    //收货地址ID
    private String receivingAddress;    //收货地址
    private BigDecimal requiredQuantity;    //需求数量
    private List<PurchasedetilVO> purchasedetilList = new ArrayList<>(); // 采购运输信息明细



    public BigDecimal getDeliveryQuantity() {
        return deliveryQuantity;
    }

    public void setDeliveryQuantity(BigDecimal deliveryQuantity) {
        this.deliveryQuantity = deliveryQuantity;
    }

    public Date getDeliveryTime() {
        return deliveryTime;
    }

    public void setDeliveryTime(Date deliveryTime) {
        this.deliveryTime = deliveryTime;
    }

    public Integer getShippingMethod() {
        return shippingMethod;
    }

    public void setShippingMethod(Integer shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    public BigDecimal getDistance() {
        return distance;
    }

    public void setDistance(BigDecimal distance) {
        this.distance = distance;
    }

    public BigDecimal getRequiredQuantity() {
        return requiredQuantity;
    }

    public void setRequiredQuantity(BigDecimal requiredQuantity) {
        this.requiredQuantity = requiredQuantity;
    }

    public void setReceivingaddressId(Long receivingaddressId) {
        this.receivingaddressId = receivingaddressId;
    }

    public void setReceivingAddress(String receivingAddress) {
        this.receivingAddress = receivingAddress;
    }



    public Long getReceivingaddressId() {
        return receivingaddressId;
    }

    public String getReceivingAddress() {
        return receivingAddress;
    }



    public List<PurchasedetilVO> getPurchasedetilList() {
        return purchasedetilList;
    }

    public void setPurchasedetilList(List<PurchasedetilVO> purchasedetilList) {
        this.purchasedetilList = purchasedetilList;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Long getMaterialplanId() {
        return materialplanId;
    }

    public void setMaterialplanId(Long materialplanId) {
        this.materialplanId = materialplanId;
    }

    @ReferSerialTransfer(referCode="SupplierinfoRef")
    public Long getSupplierinfoId() {
        return supplierinfoId;
    }
    @ReferDeserialTransfer
    public void setSupplierinfoId(Long supplierinfoId) {
        this.supplierinfoId = supplierinfoId;
    }
    public String getSupplierinfoName() {
        return supplierinfoName;
    }

    public void setSupplierinfoName(String supplierinfoName) {
        this.supplierinfoName = supplierinfoName;
    }

    @ReferSerialTransfer(referCode="ShippersRef")
    public Long getShippersId() {
        return shippersId;
    }
    @ReferDeserialTransfer
    public void setShippersId(Long shippersId) {
        this.shippersId = shippersId;
    }
    public String getShippersName() {
        return shippersName;
    }

    public void setShippersName(String shippersName) {
        this.shippersName = shippersName;
    }


    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    
}
