package com.ejianc.business.purchasingmanagement.api;

import com.ejianc.business.purchasingmanagement.hystrix.PurchaseListHystrix;

import com.ejianc.business.purchasingmanagement.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
@FeignClient(name= "ejc-purchasingmanagement-web", url="${common.env.feign-client-url}", path="ejc-purchasingmanagement-web", fallback = PurchaseListHystrix.class)
public interface PurchaseListApi {
    /**
    * @Description  采购合同列表
    */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/contractList")
    CommonResponse<PurchaseListApi> contractList(@RequestBody RequestVO requestVO);


    /**
     * @Description  供应商付款单列表
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/receiptList")
    CommonResponse<PurchaseListApi> receiptList(@RequestBody RequestVO requestVO);


    /**
     * @Description  运输商付款单列表
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/transportersReceiptList")
    CommonResponse<PurchaseListApi> transportersReceiptList(@RequestBody RequestVO requestVO);

    /**
     * @Description  采购运输单列表
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/shippingList")
    CommonResponse<PurchaseListApi> shippingList(@RequestBody RequestVO requestVO);


    /**
     * @Description  供应商发票列表
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/supplierinvoiceList")
    CommonResponse<PurchaseListApi> supplierinvoiceList(@RequestBody RequestVO requestVO);


    /**
     * @Description  运输商发票列表
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/shippersinvoiceList")
    CommonResponse<PurchaseListApi> shippersinvoiceList(@RequestBody RequestVO requestVO);


    /**
     * @Description  运输单详情
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/shipping")
    CommonResponse<PurchaseListApi> shipping(@RequestBody  RequestVO requestVO);



    /**
     * @Description  运输单保存
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/saveShipping")
    CommonResponse<PurchaseListApi> saveShipping(@RequestBody PurchasedetilVO PurchasedetilVO);
    /**
     * @Description  运输单明细删除
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/deleteShipping")
    CommonResponse<PurchaseListApi> deleteShipping(@RequestBody RequestVO RequestVO);
    @PostMapping("/api/purchasingmanagement/purchaseListApi/detailShipping")
    CommonResponse<PurchaseListApi> detailShipping(@RequestBody RequestVO RequestVO);



    /**
     * @Description  采购运输单列表
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/supplierShippingList")
    CommonResponse<PurchaseListApi> supplierShippingList(@RequestBody Request2VO requestVO);

    /**
     * @Description  采购合同列表根据原材料查询
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/contractListByID")
    CommonResponse<PurchaseListApi> contractListByID(@RequestBody RequestVO requestVO);


    @PostMapping("/api/purchasingmanagement/purchaseListApi/contractTime")
    CommonResponse<PurchaseListApi> contractTime();

    @PostMapping("/api/purchasingmanagement/purchaseListApi/purchasereceiptDetil")
    CommonResponse<PurchaseListApi> purchasereceiptDetil(@RequestBody PurchasereceiptVO purchasereceiptVO);


}
