/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quatity.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.read.listener.ReadListener;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quatity.dao.CompanyGoalsDao;
import com.ejianc.business.quatity.entity.CompanyGoalsEntity;
import com.ejianc.business.quatity.model.po.CompanyExcelPo;
import com.ejianc.business.quatity.model.vo.CompanyTargetAddVo;
import com.ejianc.business.quatity.model.vo.CompanyTargetListVo;
import com.ejianc.business.quatity.service.TargetManagementServer;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TargetManagementServerImpl
implements TargetManagementServer {
    private static final Logger log = LoggerFactory.getLogger(TargetManagementServerImpl.class);
    private final CompanyGoalsDao companyGoalsDao;
    private static final List<String> DOWNLOAD_EXCEL_TEMPLATE_LIST = Lists.newArrayList((Object[])new String[]{"company"});

    @Override
    public CompanyGoalsEntity companyAdd(CompanyTargetAddVo vo) {
        CompanyGoalsEntity companyGoalsEntity = new CompanyGoalsEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)companyGoalsEntity));
        try {
            this.companyGoalsDao.save((Object)companyGoalsEntity);
            return companyGoalsEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<CompanyGoalsEntity> companyList(CompanyTargetListVo vo) {
        String targetFile = vo.getTargetFile();
        Date startUploadTime = vo.getStartUploadTime();
        Date endUploadTime = vo.getEndUploadTime();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        if (StrUtil.isNotEmpty((CharSequence)targetFile)) {
            lambdaQuery.like(CompanyGoalsEntity::getTargetFile, (Object)targetFile);
        }
        if (Objects.nonNull(startUploadTime)) {
            lambdaQuery.between(CompanyGoalsEntity::getUploadTime, (Object)startUploadTime, (Object)endUploadTime);
        }
        return this.companyGoalsDao.page((IPage)vo.buildPage(), (Wrapper)lambdaQuery);
    }

    @Override
    public void companyDel(List<Long> ids) {
        try {
            this.companyGoalsDao.removeByIds(ids);
        }
        catch (Exception e) {
            throw new BusinessException("\u516c\u53f8\u76ee\u6807\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void companyExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.companyGoalsDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("companyGoalsExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u516c\u53f8\u76ee\u6807\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void importDownTemplateDetail(String excelName, HttpServletRequest request, HttpServletResponse response) {
        try {
            ImportTemplate.initialize((HttpServletResponse)response);
            if (!DOWNLOAD_EXCEL_TEMPLATE_LIST.contains(excelName)) {
                throw new BusinessException("\u8bf7\u6307\u5b9a\u6b63\u786e\u7684excel\u6a21\u677f\u540d\u79f0\u6216\u8054\u7cfb\u7ba1\u7406\u4eba\u5458");
            }
            if ("company".equals(excelName)) {
                ImportTemplate.templetdownload((HttpServletRequest)request, (String)"companyGoalsImport.xlsx", (String)"\u516c\u53f8\u76ee\u6807\u5bfc\u5165\u6a21\u677f");
            }
        }
        catch (BusinessException e) {
            throw new BusinessException("\u516c\u53f8\u76ee\u6807excel\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void companyExcelImport(MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
        final ArrayList companyExcelPoList = new ArrayList();
        if (file == null || file.isEmpty() || ObjectUtils.isEmpty((Object)file.getOriginalFilename())) {
            throw new BusinessException(Integer.valueOf(500), "\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fileName = file.getOriginalFilename();
        if (!fileName.endsWith(".xlsx") && !fileName.endsWith(".xls")) {
            throw new BusinessException(Integer.valueOf(500), "\u6587\u4ef6\u7c7b\u578b\u9519\u8bef\uff0c\u53ea\u652f\u6301\uff1axlsx\u3001xls");
        }
        try {
            InputStream inputStream = file.getInputStream();
            EasyExcel.read((InputStream)inputStream, CompanyExcelPo.class, (ReadListener)new AnalysisEventListener<CompanyExcelPo>(){

                public void invoke(CompanyExcelPo companyExcelPo, AnalysisContext analysisContext) {
                    companyExcelPoList.add(companyExcelPo);
                }

                public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                }
            }).sheet().doRead();
        }
        catch (IOException e) {
            log.info("\u516c\u53f8\u76ee\u6807\u5bfc\u5165\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        catch (ExcelDataConvertException e) {
            throw new BusinessException("\u516c\u53f8\u76ee\u6807\u5bfc\u5165\u5f02\u5e38");
        }
        try {
            List companyGoalsEntityList = Lists.newArrayList();
            companyExcelPoList.forEach(companyExcelPo -> {
                CompanyGoalsEntity companyGoalsEntity = new CompanyGoalsEntity();
                BeanUtils.copyProperties((Object)companyExcelPo, (Object)((Object)companyGoalsEntity));
                companyGoalsEntity.setUploadTime(DateUtil.parse((String)companyExcelPo.getUploadTime(), (String)"yyyy-MM-dd").toSqlDate());
                companyGoalsEntityList.add(companyGoalsEntity);
            });
            this.companyGoalsDao.saveBatch(companyGoalsEntityList);
        }
        catch (Exception e) {
            throw new BusinessException("\u516c\u53f8\u76ee\u6807\u5bfc\u5165\u4fdd\u5b58\u5f02\u5e38");
        }
    }

    public TargetManagementServerImpl(CompanyGoalsDao companyGoalsDao) {
        this.companyGoalsDao = companyGoalsDao;
    }
}

