package com.ejianc.business.quatity.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.InternalAuditsEntity;
import com.ejianc.business.quatity.model.vo.CompanyTargetAddVo;
import com.ejianc.business.quatity.model.vo.InternalAuditsAddVo;
import com.ejianc.business.quatity.service.InternalAuditsServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:42
 * @Description: 内部审核
 */
@Controller
@RequestMapping("internalAudits")
@RequiredArgsConstructor
public class InternalAuditsController {
    private final InternalAuditsServer server;

    /**
     * 内部审核-新增
     *
     * @param vo CompanyTargetAddVo
     * @return 结果
     * @see CompanyTargetAddVo
     */
    @RequestMapping(value = "add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InternalAuditsEntity> add(@RequestBody @Valid InternalAuditsAddVo vo) {
        return CommonResponse.success("内部审核-新增成功", server.add(vo));
    }

    /**
     * 内部审核-查询
     *
     * @param param param
     * @return IPage<InternalAuditsEntity>
     */
    @RequestMapping(value = "list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InternalAuditsEntity>> list(@RequestBody QueryParam param) {
        return CommonResponse.success("内部审核-查询", server.list(param));
    }

    /**
     * 内部审核-删除
     *
     * @param ids ids
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> del(@RequestBody @Valid List<Long> ids) {
        server.del(ids);
        return CommonResponse.success("内部审核-删除成功");
    }

    /**
     * 内部审核-导出
     *
     * @param ids      ids
     * @param response response
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> excelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.internalAuditsExcelExport(ids, response);
        return CommonResponse.success("内部审核-导出成功");
    }

    /**
     * 内部审核导入
     *
     * @param file 导入的excel文件
     * @return 结果
     */
    @RequestMapping(value = "excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> excelImport(@RequestPart("file") MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
        server.internalAuditsExcelImport(file, request, response);
        return CommonResponse.success("内部审核-导入成功");
    }

}
