package com.ejianc.business.quatity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.dao.InstitutionalLibraryDao;
import com.ejianc.business.quatity.dao.StandardLibraryDao;
import com.ejianc.business.quatity.entity.SysDocInstitutionalLibEntity;
import com.ejianc.business.quatity.entity.SysDocStandardLibEntity;
import com.ejianc.business.quatity.enums.ApplicableProjectCategoriesEnum;
import com.ejianc.business.quatity.enums.ApplicableScopeEnum;
import com.ejianc.business.quatity.enums.ManagementSystemEnum;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.enums.SystemDocumentsOriginEnum;
import com.ejianc.business.quatity.enums.SystemDocumentsStatusEnum;
import com.ejianc.business.quatity.model.vo.SysDocDelVo;
import com.ejianc.business.quatity.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quatity.model.vo.SysDocStandardAddVo;
import com.ejianc.business.quatity.service.SystemDocumentsServer;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午4:05
 * @Description: 体系文件
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class SystemDocumentsServerImpl implements SystemDocumentsServer {
    /**
     * 制度库
     */
    private static final String INSTITUTIONAL = SystemDocumentsOriginEnum.INSTITUTIONAL.getOriginCode();
    private final InstitutionalLibraryDao institutionalLibraryDao;
    /**
     * 标准库
     */
    private static final String STANDARD = SystemDocumentsOriginEnum.STANDARD.getOriginCode();
    private final StandardLibraryDao standardLibraryDao;

    @Override
    public SysDocStandardLibEntity standardAdd(SysDocStandardAddVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties(vo, sysDocStandardLibEntity);
        List<String> syfw = vo.getSyfw();
        try {
            sysDocStandardLibEntity.setSyfw(JSONObject.toJSONString(syfw));
            standardLibraryDao.save(sysDocStandardLibEntity);
            return sysDocStandardLibEntity;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public SysDocInstitutionalLibEntity institutionalAdd(SysDocInstitutionalAddVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties(vo, sysDocInstitutionalLibEntity);
        try {
            institutionalLibraryDao.save(sysDocInstitutionalLibEntity);
            return sysDocInstitutionalLibEntity;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<SysDocStandardLibEntity> standardList(QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("wjbh");
        fuzzyFields.add("wjmc");
        fuzzyFields.add("bz");
        fuzzyFields.add("txjgh");
        fuzzyFields.add("bm");

        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);
        return standardLibraryDao.queryPage(param, false);
    }


    @Override
    public IPage<SysDocInstitutionalLibEntity> institutionalList(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("zdfl");
        fuzzyFields.add("zdfj");
        fuzzyFields.add("bzbm");
        fuzzyFields.add("bzdw");
        fuzzyFields.add("zdbt");
        fuzzyFields.add("zddj");
        fuzzyFields.add("fwh");
        fuzzyFields.add("zdbm");
        fuzzyFields.add("fbrq");
        fuzzyFields.add("syjg");
        fuzzyFields.add("spjg");
        fuzzyFields.add("sjzdly");
        fuzzyFields.add("bm");
        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);
        return institutionalLibraryDao.queryPage(param, false);
    }

    @Override
    public SysDocStandardLibEntity standardDetail(Long id) {
        return standardLibraryDao.getById(id);
    }

    @Override
    public SysDocInstitutionalLibEntity institutionalDetail(Long id) {
        return institutionalLibraryDao.getById(id);
    }

    @Override
    public void del(SysDocDelVo vo) {
        String type = vo.getType();
        if (!INSTITUTIONAL.equals(type) && !STANDARD.equals(type)) {
            throw new BusinessException("文件库类型不存在:【标准库STANDARD/制度库INSTITUTIONAL】");
        }
        try {
            if (INSTITUTIONAL.equals(type)) {
                institutionalLibraryDao.removeByIds(vo.getIds());
            }
            if (STANDARD.equals(type)) {
                standardLibraryDao.removeByIds(vo.getIds());
            }
        } catch (Exception e) {
            throw new BusinessException("体系文件删除失败：" + e.getMessage());
        }
    }

    @Override
    public void standardExcelExport(List<Long> ids, HttpServletResponse response) {
        List<SysDocStandardLibEntity> list = standardLibraryDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        //导出展示类别中文处理
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());
            String syxmlb = ApplicableProjectCategoriesEnum.getNameByCode(item.getSyxmlb());
            String zt = SystemDocumentsStatusEnum.getNameByCode(item.getZt());
            String gltx = ManagementSystemEnum.getNameByCode(item.getGltx());
            String syfw = ApplicableScopeEnum.getNameByCode(item.getSyfw());

            item.setType(type);
            item.setSyxmlb(syxmlb);
            item.setZt(zt);
            item.setGltx(gltx);
            item.setSyfw(syfw);
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("standardSystemDocExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("标准库体系文件导出失败：" + e.getMessage());
        }
    }

    @Override
    public void institutionalExcelExport(List<Long> ids, HttpServletResponse response) {
        List<SysDocInstitutionalLibEntity> list = institutionalLibraryDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        //导出展示类别中文处理
        list.forEach(item -> {
            String typeName = QualityTypeEnum.getNameByCode(item.getType());
            item.setType(typeName);
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("institutionalSystemDocExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("制度库体系文件导出失败：" + e.getMessage());
        }
    }
}
