package com.ejianc.business.quatity.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.dao.CompanyGoalsDao;
import com.ejianc.business.quatity.entity.CompanyGoalsEntity;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.model.vo.CompanyTargetAddVo;
import com.ejianc.business.quatity.service.TargetManagementServer;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: LCL
 * @Date: 2024/5/13 下午2:08
 * @Description: 目标管理
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class TargetManagementServerImpl implements TargetManagementServer {
    /**
     * 公司目标
     */
    private final CompanyGoalsDao companyGoalsDao;

    @Override
    public CompanyGoalsEntity companyAdd(CompanyTargetAddVo vo) {
        CompanyGoalsEntity companyGoalsEntity = new CompanyGoalsEntity();
        BeanUtils.copyProperties(vo, companyGoalsEntity);
        try {
            companyGoalsDao.save(companyGoalsEntity);
            return companyGoalsEntity;
        } catch (Exception e) {
            throw new BusinessException("新增失败，原因：" + e.getMessage());
        }
    }

    @Override
    public IPage<CompanyGoalsEntity> companyList(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("targetFileName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("parentOrgName");

        //排序
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>(param.getOrderMap());
        orderMap.put("createTime", QueryParam.DESC);
        param.setOrderMap(orderMap);

        return companyGoalsDao.queryPage(param, false);
    }

    @Override
    public void companyDel(List<Long> ids) {
        try {
            companyGoalsDao.removeByIds(ids);
        } catch (Exception e) {
            throw new BusinessException("公司目标删除失败：" + e.getMessage());
        }
    }

    @Override
    public void companyExcelExport(List<Long> ids, HttpServletResponse response) {
        List<CompanyGoalsEntity> list = companyGoalsDao.lambdaQuery().in(BaseEntity::getId, ids).list();
        //导出展示类别中文处理
        list.forEach(item -> {
            String typeName = QualityTypeEnum.getNameByCode(item.getType());
            item.setType(typeName);
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("companyGoalsExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("公司目标导出失败：" + e.getMessage());
        }
    }

    @Override
    public void companyExcelImport(MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
//        List<CompanyGoalsExcelPo> companyGoalsExcelPoList = new ArrayList<>();
//        if (file == null || file.isEmpty() || ObjectUtils.isEmpty(file.getOriginalFilename())) {
//            throw new BusinessException(500, "文件不能为空");
//        }
//        String fileName = file.getOriginalFilename();
//        if (!(fileName.endsWith(".xlsx") || fileName.endsWith(".xls"))) {
//            throw new BusinessException(500, "文件类型错误，只支持：xlsx、xls");
//        }
//        try {
//            InputStream inputStream = file.getInputStream();
//            EasyExcel.read(inputStream, CompanyGoalsExcelPo.class, new AnalysisEventListener<CompanyGoalsExcelPo>() {
//                        @Override
//                        public void invoke(CompanyGoalsExcelPo companyGoalsExcelPo, AnalysisContext analysisContext) {
//                            companyGoalsExcelPoList.add(companyGoalsExcelPo);
//                        }
//
//                        @Override
//                        public void doAfterAllAnalysed(AnalysisContext analysisContext) {
//                        }
//                    })
//                    .sheet()
//                    .doRead();
//        } catch (IOException e) {
//            log.info("公司目标导入异常:{}", e.getMessage());
//        } catch (ExcelDataConvertException e) {
//            throw new BusinessException("公司目标导入异常");
//        }
//        try {
//            List<CompanyGoalsEntity> companyGoalsEntityList = Lists.newArrayList();
//            companyGoalsExcelPoList.forEach(companyGoalsExcelPo -> {
//                CompanyGoalsEntity companyGoalsEntity = new CompanyGoalsEntity();
//                BeanUtils.copyProperties(companyGoalsExcelPo, companyGoalsEntity);
//                companyGoalsEntity.setUploadTime(DateUtil.parse(companyGoalsExcelPo.getUploadTime(), DateFormater.SHORT_FORMAT).toSqlDate());
//                companyGoalsEntityList.add(companyGoalsEntity);
//            });
//            companyGoalsDao.saveBatch(companyGoalsEntityList);
//        } catch (Exception e) {
//            throw new BusinessException("公司目标导入保存异常");
//        }
    }
}
