/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quatity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.ejianc.business.quatity.dao.InstitutionalLibraryDao;
import com.ejianc.business.quatity.dao.StandardLibraryDao;
import com.ejianc.business.quatity.entity.SysDocInstitutionalLibEntity;
import com.ejianc.business.quatity.entity.SysDocStandardLibEntity;
import com.ejianc.business.quatity.enums.ApplicableProjectCategoriesEnum;
import com.ejianc.business.quatity.enums.ApplicableScopeEnum;
import com.ejianc.business.quatity.enums.ManagementSystemEnum;
import com.ejianc.business.quatity.enums.QualityTypeEnum;
import com.ejianc.business.quatity.enums.SystemDocumentsOriginEnum;
import com.ejianc.business.quatity.enums.SystemDocumentsStatusEnum;
import com.ejianc.business.quatity.model.vo.SysDocDelVo;
import com.ejianc.business.quatity.model.vo.SysDocInstitutionalAddVo;
import com.ejianc.business.quatity.model.vo.SysDocStandardAddVo;
import com.ejianc.business.quatity.service.SystemDocumentsServer;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SystemDocumentsServerImpl
implements SystemDocumentsServer {
    private static final Logger log = LoggerFactory.getLogger(SystemDocumentsServerImpl.class);
    private static final String INSTITUTIONAL = SystemDocumentsOriginEnum.INSTITUTIONAL.getOriginCode();
    private final InstitutionalLibraryDao institutionalLibraryDao;
    private static final String STANDARD = SystemDocumentsOriginEnum.STANDARD.getOriginCode();
    private final StandardLibraryDao standardLibraryDao;

    @Override
    public SysDocStandardLibEntity standardAdd(SysDocStandardAddVo vo) {
        SysDocStandardLibEntity sysDocStandardLibEntity = new SysDocStandardLibEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)sysDocStandardLibEntity));
        List<String> syfw = vo.getSyfw();
        try {
            sysDocStandardLibEntity.setSyfw(JSONObject.toJSONString(syfw));
            this.standardLibraryDao.save((Object)sysDocStandardLibEntity);
            return sysDocStandardLibEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public SysDocInstitutionalLibEntity institutionalAdd(SysDocInstitutionalAddVo vo) {
        SysDocInstitutionalLibEntity sysDocInstitutionalLibEntity = new SysDocInstitutionalLibEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)sysDocInstitutionalLibEntity));
        try {
            this.institutionalLibraryDao.save((Object)sysDocInstitutionalLibEntity);
            return sysDocInstitutionalLibEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<SysDocStandardLibEntity> standardList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("wjbh");
        fuzzyFields.add("wjmc");
        fuzzyFields.add("bz");
        fuzzyFields.add("txjgh");
        fuzzyFields.add("bm");
        fuzzyFields.add("orgName");
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>(param.getOrderMap());
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        return this.standardLibraryDao.queryPage(param, false);
    }

    @Override
    public IPage<SysDocInstitutionalLibEntity> institutionalList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("zdfl");
        fuzzyFields.add("zdfj");
        fuzzyFields.add("bzbm");
        fuzzyFields.add("bzdw");
        fuzzyFields.add("zdbt");
        fuzzyFields.add("zddj");
        fuzzyFields.add("fwh");
        fuzzyFields.add("zdbm");
        fuzzyFields.add("fbrq");
        fuzzyFields.add("syjg");
        fuzzyFields.add("spjg");
        fuzzyFields.add("sjzdly");
        fuzzyFields.add("bm");
        fuzzyFields.add("orgName");
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>(param.getOrderMap());
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        return this.institutionalLibraryDao.queryPage(param, false);
    }

    @Override
    public SysDocStandardLibEntity standardDetail(Long id) {
        return (SysDocStandardLibEntity)((Object)this.standardLibraryDao.getById(id));
    }

    @Override
    public SysDocInstitutionalLibEntity institutionalDetail(Long id) {
        return (SysDocInstitutionalLibEntity)((Object)this.institutionalLibraryDao.getById(id));
    }

    @Override
    public void del(SysDocDelVo vo) {
        String type = vo.getType();
        if (!INSTITUTIONAL.equals(type) && !STANDARD.equals(type)) {
            throw new BusinessException("\u6587\u4ef6\u5e93\u7c7b\u578b\u4e0d\u5b58\u5728:\u3010\u6807\u51c6\u5e93STANDARD/\u5236\u5ea6\u5e93INSTITUTIONAL\u3011");
        }
        try {
            if (INSTITUTIONAL.equals(type)) {
                this.institutionalLibraryDao.removeByIds(vo.getIds());
            }
            if (STANDARD.equals(type)) {
                this.standardLibraryDao.removeByIds(vo.getIds());
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4f53\u7cfb\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void standardExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.standardLibraryDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());
            String syxmlb = ApplicableProjectCategoriesEnum.getNameByCode(item.getSyxmlb());
            String zt = SystemDocumentsStatusEnum.getNameByCode(item.getZt());
            String gltx = ManagementSystemEnum.getNameByCode(item.getGltx());
            String syfw = ApplicableScopeEnum.getNameByCode(item.getSyfw());
            item.setType(type);
            item.setSyxmlb(syxmlb);
            item.setZt(zt);
            item.setGltx(gltx);
            item.setSyfw(syfw);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("standardSystemDocExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u6807\u51c6\u5e93\u4f53\u7cfb\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void institutionalExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.institutionalLibraryDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            String typeName = QualityTypeEnum.getNameByCode(item.getType());
            item.setType(typeName);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("institutionalSystemDocExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u5236\u5ea6\u5e93\u4f53\u7cfb\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public SystemDocumentsServerImpl(InstitutionalLibraryDao institutionalLibraryDao, StandardLibraryDao standardLibraryDao) {
        this.institutionalLibraryDao = institutionalLibraryDao;
        this.standardLibraryDao = standardLibraryDao;
    }
}

