package com.ejianc.business.quatity.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.sql.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/20 上午10:02
 * @Description: 经验反馈下达详情
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_experience_feedback_issued_detail")
public class ExperienceFeedbackIssuedDetailEntity extends BaseEntity {
    /**
     * 经验反馈下达id
     */
    @TableField(value = "issued_id")
    private Long issuedId;

    /**
     * 下达时间
     */
    @TableField(value = "release_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date releaseTime;

    /**
     * 归属类型
     */
    @TableField(value = "attribution_type")
    private String attributionType;

    /**
     * 专业
     */
    @TableField(value = "specialized")
    private String specialized;

    /**
     * 主题
     */
    @TableField(value = "topic")
    private String topic;

    /**
     * 内容
     */
    @TableField(value = "substance")
    private String substance;

    /**
     * 附件
     */
    @TableField(value = "annex")
    private String annex;

    /**
     * 上传部门id
     */
    @TableField(value = "upload_department_id")
    private String uploadDepartmentId;

    /**
     * 上传部门name
     */
    @TableField(value = "upload_department_name")
    private String uploadDepartmentName;

    /**
     * 上传时间
     */
    @TableField(value = "upload_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 上报状态（已上报 未上报）
     */
    @TableField(value = "state")
    private String state;

    /**
     * 是否入库
     */
    @TableField(value = "is_bank")
    private Boolean isBank;

    /**
     * 状态
     */
    @TableField(value = "bill_status")
    private Integer billStatus;

    /**
     * 编制人code
     */
    @TableField(value = "prepared_user_code")
    private String preparedUserCode;

    /**
     * 编制人name
     */
    @TableField(value = "prepared_user_name")
    private String preparedUserName;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;
}
