package com.ejianc.business.quatity.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/21 上午9:20
 * @Description: 经验反馈-下达-新增
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ExpFeedBackIssuedAddVo extends BaseVO {
    /**
     * 归属类型
     */
    private String attributionType;

    /**
     * 专业
     */
    private String specialized;

    /**
     * 主题
     */
    private String topic;

    /**
     * 内容
     */
    private String substance;

    /**
     * 是否一键下达 true则不需要填写下达单位 需要传值settingIds
     */
    @Builder.Default
    private Boolean isOneClickRelease = Boolean.FALSE;
    /**
     * 下达单位设置id 下达页面展示配置页面的信息
     */
    private List<Long> settingIds;

    /**
     * 下达单位
     */
    private List<String> releaseUnitsCode;
    private List<String> releaseUnitsName;
}
