package com.ejianc.business.quatity.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.sql.Date;


@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ExperienceFeedbackIssuedDetailVo extends BaseVO {
    /**
     * 经验反馈下达id
     */
    private Long issuedId;

    /**
     * 下达时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date releaseTime;

    /**
     * 归属类型
     */
    private String attributionType;

    /**
     * 专业
     */
    private String specialized;

    /**
     * 主题
     */
    private String topic;

    /**
     * 内容
     */
    private String substance;

    /**
     * 附件
     */
    private String annex;

    /**
     * 上传部门id
     */
    private String uploadDepartmentId;

    /**
     * 上传部门name
     */
    private String uploadDepartmentName;

    /**
     * 上传时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 上报状态（已上报 未上报）
     */
    private String state;

    /**
     * 状态
     */
    private Integer billStatus;

    /**
     * 编制人code
     */
    private String preparedUserCode;

    /**
     * 编制人name
     */
    private String preparedUserName;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    private String parentOrgName;
}
