package com.ejianc.business.quatity.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.CompanyGoalsEntity;
import com.ejianc.business.quatity.entity.InternalAuditsEntity;
import com.ejianc.business.quatity.model.vo.InternalAuditsAddVo;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Date: 2024/5/15 上午10:09
 * @Description: 评审管理
 */
public interface ReviewManagementServer {

    /**
     *  评审计划-新增
     * @param vo InternalAuditsAddVo
     * @return  CommonResponse<InternalAuditsEntity>
     */
    InternalAuditsEntity internalAuditsAdd(InternalAuditsAddVo vo);

    /**
     *  评审计划-查询
     * @param param param
     * @return  CommonResponse<IPage<InternalAuditsEntity>>
     */
    IPage<InternalAuditsEntity> internalAuditsList(QueryParam param);

    /**
     * 评审计划-详情
     *
     * @param id id
     * @return CompanyGoalsEntity
     */
    InternalAuditsEntity internalAuditsDetail(Long id);

    /**
     * 评审计划-删除
     *
     * @param ids ids
     */
    void internalAuditsDel(List<Long> ids);

    /**
     * 评审计划-导出
     *
     * @param ids      ids
     * @param response response
     */
    void internalAuditsExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 评审计划-导入
     *
     * @return 结果
     */
    void internalAuditsExcelImport(HttpServletRequest request, HttpServletResponse response);
}
