package com.ejianc.business.quatity.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quatity.entity.ReleaseUnitSettingsEntity;
import com.ejianc.business.quatity.entity.ReviewPlanEntity;
import com.ejianc.business.quatity.model.vo.ReleaseUnitSettingEditVo;
import com.ejianc.business.quatity.model.vo.ReviewPlanAddVo;
import com.ejianc.business.quatity.model.vo.ReviewPlanEditVo;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午9:50
 * @Description: 评审管理-计划
 */
public interface ReviewPlanServer {
    /**
     *  评审计划-新增
     * @param vo reviewPlanAddVo
     * @return  CommonResponse<reviewPlanEntity>
     */
    ReviewPlanEntity reviewPlanAdd(ReviewPlanAddVo vo);

    /**
     * 评审计划-编辑
     *
     * @param vo ReviewPlanEditVo
     * @return ReviewPlanEntity
     * @see ReviewPlanEditVo
     * @see ReviewPlanEntity
     */
    ReviewPlanEntity reviewPlanEdit(ReviewPlanEditVo vo);

    /**
     *  评审计划-查询
     * @param param param
     * @return  CommonResponse<IPage<reviewPlanEntity>>
     */
    IPage<ReviewPlanEntity> reviewPlanList(QueryParam param);

    /**
     * 评审计划-详情
     *
     * @param id id
     * @return CompanyGoalsEntity
     */
    ReviewPlanEntity reviewPlanDetail(Long id);

    /**
     * 评审计划-删除
     *
     * @param ids ids
     */
    void reviewPlanDel(List<Long> ids);

    /**
     * 评审计划-导出
     *
     * @param ids      ids
     * @param response response
     */
    void reviewPlanExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 评审计划-导入
     *
     * @return 结果
     */
    void reviewPlanExcelImport(HttpServletRequest request, HttpServletResponse response);


}
