package com.ejianc.business.quality.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;


/**
 * @Author: LCL
 * @Date: 2024/6/25 下午3:35
 * @Description: 经验反馈库
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_experience_feedback_bank")
public class ExpFeedbackBankEntity extends BaseEntity {
    /**
     * 创建者姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;
    /**
     * 更新着姓名
     */
    @TableField(value = "update_user_name")
    private String updateUserName;

    /**
     * 下达时间
     */
    @TableField(value = "release_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date releaseTime;

    /**
     * 归属类型
     */
    @TableField(value = "attribution_type")
    private String attributionType;

    /**
     * 专业
     */
    @TableField(value = "specialized")
    private String specialized;

    /**
     * 主题
     */
    @TableField(value = "topic")
    private String topic;

    /**
     * 内容
     */
    @TableField(value = "substance")
    private String substance;

    /**
     * 经验反馈详情id
     */
    @TableField(value = "detail_id")
    private Long detailId;

    /**
     * 附件名称
     */
    @TableField(value = "annex_name")
    private String annexName;

    /**
     * 上传部门id
     */
    @TableField(value = "upload_department_id")
    private Long uploadDepartmentId;

    /**
     * 上传部门name
     */
    @TableField(value = "upload_department_name")
    private String uploadDepartmentName;

    /**
     * 上传时间
     */
    @TableField(value = "upload_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date uploadTime;

    /**
     * 学习部门id
     */
    @TableField(value = "learn_unit_id")
    private Long learnUnitId;

    /**
     * 学习部门name
     */
    @TableField(value = "learn_unit_name")
    private String learnUnitName;

    /**
     * 学习时间
     */
    @TableField(value = "learn_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date learnTime;

    /**
     * 学习
     */
    @TableField(value = "learn_annex")
    private String learnAnnex;

    /**
     * 学习情况（已学习 未学习）
     */
    @TableField(value = "state")
    private String state;

    /**
     * 状态
     */
    @TableField(value = "bill_status")
    private Integer billStatus;

    /**
     * 所属项目部Id
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 所属项目部名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField(value = "parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField(value = "parent_org_name")
    private String parentOrgName;
}
