package com.ejianc.business.quality.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;


/**
 * @Author: LCL
 * @Date: 2024/6/22 下午2:56
 * @Description: 管理评审-附件
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_quality_review_annex")
public class ReviewAnnexEntity extends BaseEntity {
    /**
     * 创建者名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 修改者名称
     */
    @TableField(value = "update_user_name")
    private String updateUserName;

    /**
     * 文件名称
     */
    @TableField(value = "file_name")
    private String fileName;

    /**
     * 模板适用年份
     */
    @TableField(value = "file_year")
    private String fileYear;

    /**
     * 附件
     */
    @TableField(value = "annex")
    private String annex;
}
