package com.ejianc.business.quality.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Author: LCL
 * @Date: 2024/5/14 下午4:15
 * @Description: 不符合项——管理类型(市场、风险、安全、质量、环境、人资、技术、生产设备、测量、合同、采购、仓储、班组)
 */
@Getter
@AllArgsConstructor
public enum NonConformityTypeEnum {
    /**
     * 市场管理
     */
    SC("SC", "市场管理"),
    /**
     * 风险管理
     */
    FX("FX", "风险管理"),
    /**
     * 安全管理
     */
    AQ("AQ", "安全管理"),
    /**
     * 质量管理
     */
    ZL("ZL", "质量管理"),
    /**
     * 环境管理
     */
    HJ("HJ", "环境管理"),
    /**
     * 人资管理
     */
    RZ("RZ", "人资管理"),
    /**
     * 技术管理
     */
    JS("JS", "技术管理"),
    /**
     * 生产设备管理
     */
    SCSB("SCSB", "生产设备管理"),
    /**
     * 测量管理
     */
    CL("CL", "测量管理"),
    /**
     * 合同管理
     */
    HT("HT", "合同管理"),
    /**
     * 采购管理
     */
    CG("CG", "采购管理"),
    /**
     * 仓储管理
     */
    CC("CC", "仓储管理"),
    /**
     * 班组管理
     */
    BZ("BZ", "班组管理"),
    ;

    private final String typeCode;

    private final String typeName;

    public static final NonConformityTypeEnum[] VALUES;

    static {
        VALUES = values();
    }

    public static final List<String> CODELIST = Arrays.stream(VALUES).map(NonConformityTypeEnum::getTypeCode).collect(Collectors.toList());

    public static String getNameByCode(String typeCode) {
        for (NonConformityTypeEnum managementSystemEnum : values()) {
            if (managementSystemEnum.getTypeCode().equals(typeCode)) {
                return managementSystemEnum.getTypeName();
            }
        }
        return "未知";
    }

    public static String getCodeByName(String typeName) {
        for (NonConformityTypeEnum managementSystemEnum : values()) {
            if (managementSystemEnum.getTypeName().equals(typeName)) {
                return managementSystemEnum.getTypeCode();
            }
        }
        return "errorCode";
    }
}
