package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.sql.Date;


/**
 * @Author: LCL
 * @Date: 2024/5/17 上午10:28
 * @Description:
 * @Description: 内部审核编辑
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
public class InternalAuditsEditVo extends BaseVO {
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quality.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;

    /**
     * 审核报告名称
     */
    private String auditReportsName;

    /**
     * 审核报告url
     */
    private String auditReports;

    /**
     * 审核计划名称
     */
    private String auditPlanName;

    /**
     * 审核计划url
     */
    private String auditPlan;

    /**
     * 目标上传日期
     */
    private Date uploadTime;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;
}
