package com.ejianc.business.quality.model.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/5/17 下午3:28
 * @Description: 下达单位设置
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ReleaseUnitSettingsVo extends BaseVO {
    /**
     * 所属类型(管理评审输入、经验反馈)
     */
    private String type;

    /**
     * 编制人账号
     */
    private String preparedUserCode;

    /**
     * 所属项目部Id
     */
    private Long orgId;

    /**
     * 所属项目部名称
     */
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    private String parentOrgName;

    /**
     * 子表信息
     */
    @NotEmpty(message = "下达单位不能为空")
    private List<ReleaseUnitSettingsDetailVo> subList;
}
