package com.ejianc.business.quality.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.model.vo.ExpFeedbackBankVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/6/25 下午3:42
 * @Description: 经验反馈库
 */
public interface ExpFeedbackBankServer {
    /**
     * 入库
     *
     * @param ids ids
     * @return List<ExpFeedbackBankVo>
     */
    CommonResponse<List<ExpFeedbackBankVo>> enterBank(List<Long> ids);

    /**
     * 新增或编辑
     *
     * @param saveOrUpdateVO saveOrUpdateVO
     * @return ExpFeedbackBankVo
     */
    ExpFeedbackBankVo saveOrUpdate(ExpFeedbackBankVo saveOrUpdateVO);

    /**
     * 删除
     *
     * @param ids ids
     * @return 结果
     */
    CommonResponse<Object> del(List<Long> ids);

    /**
     * 详情
     *
     * @param id id
     * @return ExpFeedbackBankVo
     */
    ExpFeedbackBankVo detail(Long id);

    /**
     * 查询
     *
     * @param param param
     * @return IPage<ExpFeedbackBankVo>
     */
    IPage<ExpFeedbackBankVo> list(QueryParam param);
}
