package com.ejianc.business.quality.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.model.vo.ExpFeedBackIssuedVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/15 上午10:09
 * @Description: 经验反馈下达
 */
public interface ExpFeedbackIssuedServer {
    /**
     * 新增或编辑
     *
     * @param saveOrUpdateVO saveOrUpdateVO
     * @return ExpFeedBackIssuedVo
     */

    ExpFeedBackIssuedVo saveOrUpdate(ExpFeedBackIssuedVo saveOrUpdateVO);

    /**
     * 下达
     * @param idList ids
     */
    void issued(List<Long> idList);

    /**
     * 删除
     *
     * @param ids ids
     * @return 结果
     */
    CommonResponse<Object> del(List<Long> ids);

    /**
     * 详情
     *
     * @param id id
     * @return ExpFeedBackIssuedVo
     */
    ExpFeedBackIssuedVo detail(Long id);

    /**
     * 查询
     *
     * @param param param
     * @return IPage<ExpFeedBackIssuedVo>
     */
    IPage<ExpFeedBackIssuedVo> list(QueryParam param);

    /**
     * 导出
     *
     * @param ids      ids
     * @param response 文件
     */
    void excelExport(List<Long> ids, HttpServletResponse response);

}
