package com.ejianc.business.quality.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.entity.InternalAuditsEntity;
import com.ejianc.business.quality.entity.NonConformityEntity;
import com.ejianc.business.quality.model.vo.CompanyTargetAddVo;
import com.ejianc.business.quality.model.vo.InternalAuditsAddVo;
import com.ejianc.business.quality.model.vo.InternalAuditsEditVo;
import com.ejianc.business.quality.model.vo.NonConformityAddVo;
import com.ejianc.business.quality.model.vo.NonConformityEditVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/5/14 上午9:43
 * @Description: 内部审核
 */
public interface InternalAuditsServer {

    /**
     * 内部审核-新增
     *
     * @param vo InternalAuditsAddVo
     * @return 结果
     * @see InternalAuditsEntity
     */
    InternalAuditsEntity add(InternalAuditsAddVo vo);

    /**
     * 内部审核-编辑
     *
     * @param vo InternalAuditsEditVo
     * @return 结果
     * @see InternalAuditsEntity
     */
    InternalAuditsEntity edit(InternalAuditsEditVo vo);

    /**
     * 内部审核-查询
     *
     * @param param param
     * @return IPage<InternalAuditsEntity>
     */
    IPage<InternalAuditsEntity> list(QueryParam param);

    /**
     * 内部审核-详情
     *
     * @param id id
     * @return InternalAuditsEntity
     */
    InternalAuditsEntity detail(Long id);

    /**
     * 内部审核-删除
     *
     * @param ids ids
     */
    void del(List<Long> ids);

    /**
     * 内部审核-导出
     *
     * @param ids      ids
     * @param response response
     */
    void internalAuditsExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 内部审核导入
     *
     * @param request request
     * @return 结果
     */
    CommonResponse<JSONObject> internalAuditsExcelImport(HttpServletRequest request);

    /**
     * 内部审核导入保存
     *
     * @param importVos importVos
     */
    void excelImportSave(List<InternalAuditsEntity> importVos);

    /**
     * 不符合项-新增
     *
     * @param vo NonConformityAddVo
     * @return 结果
     * @see CompanyTargetAddVo
     */
    NonConformityEntity nonConformityAdd(NonConformityAddVo vo);

    /**
     * 不符合项-编辑
     *
     * @param vo NonConformityAddVo
     * @return 结果
     * @see CompanyTargetAddVo
     * @see CompanyTargetAddVo
     */
    NonConformityEntity nonConformityEdit(NonConformityEditVo vo);

    /**
     * 不符合项-查询
     *
     * @param param param
     * @return IPage<InternalAuditsEntity>
     */
    IPage<NonConformityEntity> nonConformityList(QueryParam param);

    /**
     * 不符合项-详情
     *
     * @param id id
     * @return InternalAuditsEntity
     */
    NonConformityEntity nonConformityDetail(Long id);

    /**
     * 不符合项-删除
     *
     * @param ids ids
     */
    void nonConformityDel(List<Long> ids);

    /**
     * 不符合项导入
     *
     * @param excelType 类型 observe观察项  ncr NCR
     * @param request   request
     * @return 结果
     */
    CommonResponse<JSONObject> nonConformityExcelImport(String excelType, HttpServletRequest request);

    /**
     * 不符合项导入保存
     *
     * @param importVos importVos
     */
    void nonConformityExcelImportSave(List<NonConformityEntity> importVos);

    /**
     * 不符合-导出
     *
     * @param ids      ids
     * @param response response
     */
    void nonConformityExcelExport(List<Long> ids, HttpServletResponse response);

    /**
     * 不符合-获取年份
     *
     * @return List<Object>
     */
    CommonResponse<List<Object>> nonConformityGetYear();

    /**
     * 不符合-统计
     *
     * @return 结果
     */
    CommonResponse<JSONObject> nonConformityStatistics();
}
