package com.ejianc.business.quality.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDao;
import com.ejianc.business.quality.dao.ExpFeedbackIssuedDetailDao;
import com.ejianc.business.quality.dao.ReleaseUnitSettingsDetailDao;
import com.ejianc.business.quality.entity.ExperienceFeedbackIssuedDetailEntity;
import com.ejianc.business.quality.entity.ExperienceFeedbackIssuedEntity;
import com.ejianc.business.quality.entity.ReleaseUnitSettingsDetailEntity;
import com.ejianc.business.quality.model.vo.ExpFeedBackIssuedVo;
import com.ejianc.business.quality.model.vo.ExpFeedbackIssuedDetailVo;
import com.ejianc.business.quality.model.vo.bpm.BatchSubmitVO;
import com.ejianc.business.quality.service.ExpFeedbackIssuedServer;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.google.common.collect.Maps;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.sql.Date;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Author: LCL
 * @Date: 2024/5/15 上午10:10
 */
@SuppressWarnings("SpringQualifierCopyableLombok")
@Service
@Slf4j
@RequiredArgsConstructor
public class ExpFeedbackIssuedServerImpl implements ExpFeedbackIssuedServer {
    private final ExpFeedbackIssuedDao dao;
    private final ExpFeedbackIssuedDetailDao detailDao;
    private final SessionManager sessionManager;

    private final ReleaseUnitSettingsDetailDao releaseUnitSettingsDetailDao;


    @Qualifier("com.ejianc.foundation.bpm.api.IBpmApi")
    private final IBpmApi iBpmApi;
    @Value("${common.env.base-host}")
    private String baseHost;

    @Override
    public ExpFeedBackIssuedVo saveOrUpdate(ExpFeedBackIssuedVo saveOrUpdateVO) {
        UserContext userContext = sessionManager.getUserContext();
        ExperienceFeedbackIssuedEntity entity = BeanMapper.map(saveOrUpdateVO, ExperienceFeedbackIssuedEntity.class);
        Long id = entity.getId();
        if (id == null) {
            entity.setCreateUserName(userContext.getUserName());
            //下达时间
            entity.setReleaseTime(new Date(System.currentTimeMillis()));
            //完成情况
            entity.setIsIssued(false);
            entity.setCompletion("未完成");
            entity.setOrgId(userContext.getOrgId());
            entity.setOrgName(userContext.getOrgName());
            entity.setParentOrgId(userContext.getDeptId());
            entity.setParentOrgName(userContext.getDeptName());
        } else {
            entity.setUpdateUserName(userContext.getUserName());
            entity.setCreateUserName(dao.getById(id).getCreateUserName());
        }

        dao.saveOrUpdate(entity, false);

        ExpFeedBackIssuedVo expFeedBackIssuedVo = new ExpFeedBackIssuedVo();
        BeanUtil.copyProperties(entity, expFeedBackIssuedVo);
        return expFeedBackIssuedVo;
    }

    @Override
    public List<ExperienceFeedbackIssuedDetailEntity> issued(List<Long> idList) {
        List<ReleaseUnitSettingsDetailEntity> settingsDetailEntityList = releaseUnitSettingsDetailDao.lambdaQuery()
                .eq(ReleaseUnitSettingsDetailEntity::getType, "经验反馈").list();
        if (settingsDetailEntityList.isEmpty()) {
            throw new BusinessException("暂无经验反馈下达配置，请先配置！");
        }

        List<Long> releaseUnitIds = settingsDetailEntityList.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnits).collect(Collectors.toList());
        List<String> releaseUnitName = settingsDetailEntityList.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnitsName).collect(Collectors.toList());

        List<ExperienceFeedbackIssuedEntity> entityList = dao.lambdaQuery().in(BaseEntity::getId, idList).list();

        entityList.forEach(e -> {
            String releaseUnitIdsStr = StrUtil.toString(releaseUnitIds).replace("[", "").replace("]", "").trim();
            e.setReleaseUnitsId(releaseUnitIdsStr);
            String releaseUnitNameStr = StrUtil.toString(releaseUnitName).replace("[", "").replace("]", "").trim();
            e.setReleaseUnitsName(releaseUnitNameStr);
            e.setIsIssued(true);
        });
        dao.saveOrUpdateBatch(entityList);

        List<ExperienceFeedbackIssuedDetailEntity> saveEntityList = Lists.newArrayList();
        saveOrUpdateDetail(entityList, settingsDetailEntityList, saveEntityList);

        detailDao.saveOrUpdateBatch(saveEntityList);

        return saveEntityList;
    }

    private void saveOrUpdateDetail(List<ExperienceFeedbackIssuedEntity> entity, List<ReleaseUnitSettingsDetailEntity> settingsDetailEntityList,
                                    List<ExperienceFeedbackIssuedDetailEntity> saveEntityList) {
        UserContext userContext = sessionManager.getUserContext();
        for (ExperienceFeedbackIssuedEntity experienceFeedbackIssuedEntity : entity) {
            for (ReleaseUnitSettingsDetailEntity unitSettingsDetailEntity : settingsDetailEntityList) {
                ExpFeedbackIssuedDetailVo expFeedbackIssuedDetailVo = new ExpFeedbackIssuedDetailVo();

                expFeedbackIssuedDetailVo.setCreateUserName(userContext.getUserName());
                expFeedbackIssuedDetailVo.setIssuedId(experienceFeedbackIssuedEntity.getId());
                expFeedbackIssuedDetailVo.setReleaseTime(new Date(System.currentTimeMillis()));
                expFeedbackIssuedDetailVo.setAttributionType(experienceFeedbackIssuedEntity.getAttributionType());
                expFeedbackIssuedDetailVo.setSpecialized(experienceFeedbackIssuedEntity.getSpecialized());
                expFeedbackIssuedDetailVo.setTopic(experienceFeedbackIssuedEntity.getTopic());
                expFeedbackIssuedDetailVo.setSubstance(experienceFeedbackIssuedEntity.getSubstance());
                expFeedbackIssuedDetailVo.setUploadDepartmentId(String.valueOf(unitSettingsDetailEntity.getReleaseUnits()));
                expFeedbackIssuedDetailVo.setUploadDepartmentName(unitSettingsDetailEntity.getReleaseUnitsName());
                expFeedbackIssuedDetailVo.setCharge(unitSettingsDetailEntity.getCharge());
                expFeedbackIssuedDetailVo.setChargeName(unitSettingsDetailEntity.getChargeName());
                expFeedbackIssuedDetailVo.setState("未上报");
                expFeedbackIssuedDetailVo.setLearnState("未学习");
                expFeedbackIssuedDetailVo.setOrgId(userContext.getOrgId());
                expFeedbackIssuedDetailVo.setOrgName(userContext.getOrgName());
                expFeedbackIssuedDetailVo.setParentOrgId(userContext.getDeptId());
                expFeedbackIssuedDetailVo.setParentOrgName(userContext.getDeptName());
                ExperienceFeedbackIssuedDetailEntity saveEntity = BeanMapper.map(expFeedbackIssuedDetailVo, ExperienceFeedbackIssuedDetailEntity.class);
                saveEntityList.add(saveEntity);
            }
        }

    }

    @Override
    public CommonResponse<Object> batchSubmit(BatchSubmitVO vo) {
        if (Objects.isNull(vo) || vo.getDetailList().isEmpty() || StrUtil.isEmpty(vo.getBillTypeCode())) {
            return CommonResponse.error("批量提交失败！参数错误");
        }
        try {
            List<BatchSubmitVO.BatchSubmitDetailVO> detailList = vo.getDetailList();
            for (BatchSubmitVO.BatchSubmitDetailVO detail : detailList) {
                Map<String, Object> submitParam = Maps.newHashMap();
                submitParam.put("userId", InvocationInfoProxy.getUserid());
                submitParam.put("billtypeId", vo.getBillTypeCode());
                submitParam.put("businessKey", detail.getId());
                submitParam.put("formurl", baseHost + "/ejc-ztpczr-frontend/#/" + vo.getPath() + "/card?id=" + detail.getId());
                submitParam.put("procInstName", "经验反馈" + detail.getId() + DateFormatUtils.format(new java.util.Date(), "yyyy-MM-dd"));
                submitParam.put("billOrgId", detail.getOrgId());
                submitParam.put("messageType", new String[]{"sys"});
                CommonResponse<String> result = iBpmApi.doSubmit(submitParam);
                if (!result.isSuccess()) {
                    return CommonResponse.error(result.getMsg());
                }
            }
            return CommonResponse.success("批量提交成功！");
        } catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("批量提交失败！错误信息：", e);
            }
            return CommonResponse.error("批量提交失败！");
        }
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            dao.removeByIds(ids, true);
            detailDao.lambdaUpdate().in(ExperienceFeedbackIssuedDetailEntity::getIssuedId, ids).remove();
            return CommonResponse.success("删除成功！");
        } catch (Exception e) {
            return CommonResponse.success("删除失败:" + e.getMessage());
        }
    }

    @Override
    public ExpFeedBackIssuedVo detail(Long id, String state) {
        ExperienceFeedbackIssuedEntity experienceFeedbackIssuedEntity = dao.selectById(id);
        ExpFeedBackIssuedVo expFeedBackIssuedVo = new ExpFeedBackIssuedVo();
        BeanUtil.copyProperties(experienceFeedbackIssuedEntity, expFeedBackIssuedVo);

        if (StrUtil.isNotBlank(experienceFeedbackIssuedEntity.getReleaseUnitsName())) {
            List<String> strings = StrUtil.splitTrim(experienceFeedbackIssuedEntity.getReleaseUnitsName(), ",");
            expFeedBackIssuedVo.setReleaseUnitsName(strings);

            List<String> strings1 = StrUtil.splitTrim(experienceFeedbackIssuedEntity.getReleaseUnitsId(), ",");
            expFeedBackIssuedVo.setReleaseUnitsId(strings1);
        }

        List<ExpFeedbackIssuedDetailVo> expFeedbackIssuedDetailVoList = detailDao.lambdaQuery().in(ExperienceFeedbackIssuedDetailEntity::getIssuedId, id)
                .list().stream().map(e -> {
                    ExpFeedbackIssuedDetailVo expFeedbackIssuedDetailVo = new ExpFeedbackIssuedDetailVo();
                    BeanUtil.copyProperties(e, expFeedbackIssuedDetailVo);
                    return expFeedbackIssuedDetailVo;
                }).collect(Collectors.toList());
        if (StrUtil.isNotBlank(state)) {
            switch (state) {
                case "Y":
                    expFeedbackIssuedDetailVoList = expFeedbackIssuedDetailVoList.stream().filter(e -> "已上报".equals(e.getState())).collect(Collectors.toList());
                    break;
                case "W":
                    expFeedbackIssuedDetailVoList = expFeedbackIssuedDetailVoList.stream().filter(e -> "未上报".equals(e.getState())).collect(Collectors.toList());
                    break;
                default:
                    break;
            }
        }
        expFeedBackIssuedVo.setDetailList(expFeedbackIssuedDetailVoList);
        return expFeedBackIssuedVo;
    }

    @Override
    public IPage<ExpFeedBackIssuedVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("attributionType", "specialized", "createUserName", "topic"
                , "substance", "releaseUnitsName"));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<ExperienceFeedbackIssuedEntity> page = dao.queryPage(param, false);
        IPage<ExpFeedBackIssuedVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ExpFeedBackIssuedVo> objects = Lists.newArrayList();

        for (ExperienceFeedbackIssuedEntity record : page.getRecords()) {
            ExpFeedBackIssuedVo expFeedBackIssuedVo = new ExpFeedBackIssuedVo();
            BeanUtil.copyProperties(record, expFeedBackIssuedVo);
            if (StrUtil.isNotBlank(record.getReleaseUnitsName())) {
                List<String> strings = StrUtil.splitTrim(record.getReleaseUnitsName(), ",");
                expFeedBackIssuedVo.setReleaseUnitsName(strings);
                List<String> strings1 = StrUtil.splitTrim(record.getReleaseUnitsId(), ",");
                expFeedBackIssuedVo.setReleaseUnitsId(strings1);
            }
            List<ExpFeedbackIssuedDetailVo> reviewIssuedDetailVoList = detailDao.lambdaQuery().in(ExperienceFeedbackIssuedDetailEntity::getIssuedId, record.getId())
                    .list().stream().map(e -> {
                        ExpFeedbackIssuedDetailVo expFeedbackIssuedDetailVo = new ExpFeedbackIssuedDetailVo();
                        BeanUtil.copyProperties(e, expFeedbackIssuedDetailVo);
                        return expFeedbackIssuedDetailVo;
                    }).collect(Collectors.toList());
            expFeedBackIssuedVo.setDetailList(reviewIssuedDetailVoList);

            objects.add(expFeedBackIssuedVo);
        }

        pageData.setRecords(objects);

        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List<ExperienceFeedbackIssuedEntity> list = dao.lambdaQuery().in(BaseEntity::getId, ids).list();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("expFeedbackIssuedExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("经验反馈下达导出失败：" + e.getMessage());
        }

    }
}
