package com.ejianc.business.quality.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.ReleaseUnitSettingsDetailDao;
import com.ejianc.business.quality.dao.ReviewIssuedDao;
import com.ejianc.business.quality.dao.ReviewIssuedDetailDao;
import com.ejianc.business.quality.entity.ReleaseUnitSettingsDetailEntity;
import com.ejianc.business.quality.entity.ReviewIssuedDetailEntity;
import com.ejianc.business.quality.entity.ReviewIssuedEntity;
import com.ejianc.business.quality.model.vo.ReviewIssuedDetailVo;
import com.ejianc.business.quality.model.vo.ReviewIssuedVo;
import com.ejianc.business.quality.model.vo.bpm.BatchSubmitVO;
import com.ejianc.business.quality.service.ReviewIssuedServer;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.google.common.collect.Maps;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;


/**
 * @Author: LCL
 * @Date: 2024/6/22 下午3:00
 */
@SuppressWarnings("SpringQualifierCopyableLombok")
@Service
@Slf4j
@RequiredArgsConstructor
@Transactional(rollbackFor = Exception.class)
public class ReviewIssuedServerImpl implements ReviewIssuedServer {
    private final ReviewIssuedDao dao;
    private final SessionManager sessionManager;

    private final ReviewIssuedDetailDao detailDao;

    private final ReleaseUnitSettingsDetailDao releaseUnitSettingsDetailDao;


    @Qualifier("com.ejianc.foundation.bpm.api.IBpmApi")
    private final IBpmApi iBpmApi;
    @Value("${common.env.base-host}")
    private String baseHost;

    @Override
    public ReviewIssuedVo saveOrUpdate(ReviewIssuedVo saveOrUpdateVO) {
        UserContext userContext = sessionManager.getUserContext();
        ReviewIssuedEntity entity = BeanMapper.map(saveOrUpdateVO, ReviewIssuedEntity.class);
        Long id = entity.getId();
        if (id == null) {
            entity.setCreateUserName(userContext.getUserName());
            entity.setIsIssued(false);
        } else {
            entity.setUpdateUserName(userContext.getUserName());
            entity.setCreateUserName(dao.getById(id).getCreateUserName());
        }

        entity.setCompletion("未完成");

        dao.saveOrUpdate(entity, false);
        ReviewIssuedVo reviewIssuedVo = new ReviewIssuedVo();
        BeanUtil.copyProperties(entity, reviewIssuedVo);

        return reviewIssuedVo;
    }

    @Override
    public List<ReviewIssuedDetailEntity> issued(List<Long> idList) {
        List<ReleaseUnitSettingsDetailEntity> settingsDetailEntityList = releaseUnitSettingsDetailDao.lambdaQuery()
                .eq(ReleaseUnitSettingsDetailEntity::getType, "管理评审输入").list();
        if (settingsDetailEntityList.isEmpty()) {
            throw new BusinessException("暂无管理评审输入下达配置，请先配置！");
        }
        List<ReviewIssuedEntity> issuedEntityList = dao.lambdaQuery().in(BaseEntity::getId, idList).list();
        List<Long> releaseUnitIds = settingsDetailEntityList.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnits).collect(Collectors.toList());
        List<String> releaseUnitName = settingsDetailEntityList.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnitsName).collect(Collectors.toList());

        issuedEntityList.forEach(e -> {
            String releaseUnitIdsStr = StrUtil.toString(releaseUnitIds).replace("[", "").replace("]", "").trim();
            e.setReleaseUnitsId(releaseUnitIdsStr);
            String releaseUnitNameStr = StrUtil.toString(releaseUnitName).replace("[", "").replace("]", "").trim();
            e.setReleaseUnitsName(releaseUnitNameStr);
            e.setIsIssued(false);
        });
        dao.saveOrUpdateBatch(issuedEntityList);
        List<ReviewIssuedDetailEntity> saveEntityList = Lists.newArrayList();

        saveOrUpdateDetail(issuedEntityList, settingsDetailEntityList, saveEntityList);

        detailDao.saveOrUpdateBatch(saveEntityList);

        return saveEntityList;
    }

    private void saveOrUpdateDetail(List<ReviewIssuedEntity> issuedEntityList, List<ReleaseUnitSettingsDetailEntity> settingsDetailEntityList,
                                    List<ReviewIssuedDetailEntity> saveEntityList) {

        for (ReviewIssuedEntity entity : issuedEntityList) {
            for (ReleaseUnitSettingsDetailEntity unitSettingsDetailEntity : settingsDetailEntityList) {
                ReviewIssuedDetailVo reviewIssuedDetailVo = new ReviewIssuedDetailVo();

                reviewIssuedDetailVo.setTopic(entity.getTopic());
                reviewIssuedDetailVo.setContent(entity.getContent());
                reviewIssuedDetailVo.setUploadUnitId(String.valueOf(unitSettingsDetailEntity.getReleaseUnits()));
                reviewIssuedDetailVo.setUploadUnitName(unitSettingsDetailEntity.getReleaseUnitsName());
                reviewIssuedDetailVo.setCharge(unitSettingsDetailEntity.getCharge());
                reviewIssuedDetailVo.setChargeName(unitSettingsDetailEntity.getChargeName());
                reviewIssuedDetailVo.setCreateUserName(sessionManager.getUserContext().getUserName());
                reviewIssuedDetailVo.setOrgId(sessionManager.getUserContext().getOrgId());
                reviewIssuedDetailVo.setOrgName(sessionManager.getUserContext().getOrgName());
                ReviewIssuedDetailEntity saveEntity = BeanMapper.map(reviewIssuedDetailVo, ReviewIssuedDetailEntity.class);
                saveEntity.setIssuedId(entity.getId());
                saveEntity.setState("未上报");
                saveEntityList.add(saveEntity);
            }
        }
    }

    @Override
    public CommonResponse<Object> batchSubmit(BatchSubmitVO vo) {
        if (Objects.isNull(vo) || vo.getDetailList().isEmpty() || StrUtil.isEmpty(vo.getBillTypeCode())) {
            return CommonResponse.error("批量提交失败！参数错误");
        }
        try {
            List<BatchSubmitVO.BatchSubmitDetailVO> detailList = vo.getDetailList();
            for (BatchSubmitVO.BatchSubmitDetailVO detail : detailList) {
                Map<String, Object> submitParam = Maps.newHashMap();
                submitParam.put("userId", InvocationInfoProxy.getUserid());
                submitParam.put("billtypeId", vo.getBillTypeCode());
                submitParam.put("businessKey", detail.getId());
                submitParam.put("formurl", baseHost + "/ejc-ztpczr-frontend/#/" + vo.getPath() + "/card?id=" + detail.getId());
                submitParam.put("procInstName", "评审管理" + detail.getId() + DateFormatUtils.format(new Date(), "yyyy-MM-dd"));
                submitParam.put("billOrgId", detail.getOrgId());
                submitParam.put("messageType", new String[]{"sys"});
                CommonResponse<String> result = iBpmApi.doSubmit(submitParam);
                if (!result.isSuccess()) {
                    return CommonResponse.error(result.getMsg());
                }
            }
            return CommonResponse.success("批量提交成功！");
        } catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("批量提交失败！错误信息：", e);
            }
            return CommonResponse.error("批量提交失败！");
        }
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            dao.removeByIds(ids, true);
            detailDao.lambdaUpdate().in(ReviewIssuedDetailEntity::getIssuedId, ids).remove();
            return CommonResponse.success("删除成功！");
        } catch (Exception e) {
            return CommonResponse.success("删除失败:" + e.getMessage());
        }
    }

    @Override
    public ReviewIssuedVo detail(Long id, String state) {
        ReviewIssuedEntity reviewIssuedEntity = dao.selectById(id);
        ReviewIssuedVo reviewIssuedVo = new ReviewIssuedVo();
        BeanUtil.copyProperties(reviewIssuedEntity, reviewIssuedVo);

        if (StrUtil.isNotBlank(reviewIssuedEntity.getReleaseUnitsName())) {
            List<String> strings = StrUtil.splitTrim(reviewIssuedEntity.getReleaseUnitsName(), ",");
            reviewIssuedVo.setReleaseUnitsName(strings);

            List<String> strings1 = StrUtil.splitTrim(reviewIssuedEntity.getReleaseUnitsId(), ",");
            reviewIssuedVo.setReleaseUnitsId(strings1);
        }


        List<ReviewIssuedDetailVo> reviewIssuedDetailVoList = detailDao.lambdaQuery().in(ReviewIssuedDetailEntity::getIssuedId, id)
                .list().stream().map(e -> {
                    ReviewIssuedDetailVo reviewIssuedDetailVo = new ReviewIssuedDetailVo();
                    BeanUtil.copyProperties(e, reviewIssuedDetailVo);
                    return reviewIssuedDetailVo;
                }).collect(Collectors.toList());
        if (StrUtil.isNotBlank(state)) {
            switch (state) {
                case "Y":
                    reviewIssuedDetailVoList = reviewIssuedDetailVoList.stream().filter(e -> "已上报".equals(e.getState())).collect(Collectors.toList());
                    break;
                case "W":
                    reviewIssuedDetailVoList = reviewIssuedDetailVoList.stream().filter(e -> "未上报".equals(e.getState())).collect(Collectors.toList());
                    break;
                default:
                    break;
            }
            reviewIssuedDetailVoList = reviewIssuedDetailVoList.stream().filter(e -> e.getState().equals(state)).collect(Collectors.toList());
        }
        reviewIssuedVo.setDetailList(reviewIssuedDetailVoList);
        return reviewIssuedVo;
    }

    @Override
    public IPage<ReviewIssuedVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("topic", "releaseUnitsName", "createUserName"));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<ReviewIssuedEntity> page = dao.queryPage(param, false);
        IPage<ReviewIssuedVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ReviewIssuedVo> objects = Lists.newArrayList();

        for (ReviewIssuedEntity record : page.getRecords()) {
            ReviewIssuedVo reviewIssuedVo = new ReviewIssuedVo();
            BeanUtil.copyProperties(record, reviewIssuedVo);
            if (StrUtil.isNotBlank(record.getReleaseUnitsName())) {
                List<String> strings = StrUtil.splitTrim(record.getReleaseUnitsName(), ",");
                reviewIssuedVo.setReleaseUnitsName(strings);
                List<String> strings1 = StrUtil.splitTrim(record.getReleaseUnitsId(), ",");
                reviewIssuedVo.setReleaseUnitsId(strings1);
            }
            List<ReviewIssuedDetailVo> reviewIssuedDetailVoList = detailDao.lambdaQuery().in(ReviewIssuedDetailEntity::getIssuedId, record.getId())
                    .list().stream().map(e -> {
                        ReviewIssuedDetailVo reviewIssuedDetailVo = new ReviewIssuedDetailVo();
                        BeanUtil.copyProperties(e, reviewIssuedDetailVo);
                        return reviewIssuedDetailVo;
                    }).collect(Collectors.toList());
            reviewIssuedVo.setDetailList(reviewIssuedDetailVoList);

            objects.add(reviewIssuedVo);
        }

        pageData.setRecords(objects);

        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List<ReviewIssuedEntity> list = dao.lambdaQuery().in(BaseEntity::getId, ids).list();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewIssuedExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("管理评审下达导出失败：" + e.getMessage());
        }

    }
}
