/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.additional.update.impl.LambdaUpdateChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.ReleaseUnitSettingsDetailDao;
import com.ejianc.business.quality.dao.ReviewIssuedDao;
import com.ejianc.business.quality.dao.ReviewIssuedDetailDao;
import com.ejianc.business.quality.entity.ReleaseUnitSettingsDetailEntity;
import com.ejianc.business.quality.entity.ReviewIssuedDetailEntity;
import com.ejianc.business.quality.entity.ReviewIssuedEntity;
import com.ejianc.business.quality.model.vo.ReviewIssuedDetailVo;
import com.ejianc.business.quality.model.vo.ReviewIssuedVo;
import com.ejianc.business.quality.model.vo.bpm.BatchSubmitVO;
import com.ejianc.business.quality.service.ReviewIssuedServer;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ReviewIssuedServerImpl
implements ReviewIssuedServer {
    private static final Logger log = LoggerFactory.getLogger(ReviewIssuedServerImpl.class);
    private final ReviewIssuedDao dao;
    private final SessionManager sessionManager;
    private final ReviewIssuedDetailDao detailDao;
    private final ReleaseUnitSettingsDetailDao releaseUnitSettingsDetailDao;
    @Qualifier(value="com.ejianc.foundation.bpm.api.IBpmApi")
    private final IBpmApi iBpmApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public ReviewIssuedVo saveOrUpdate(ReviewIssuedVo saveOrUpdateVO) {
        UserContext userContext = this.sessionManager.getUserContext();
        ReviewIssuedEntity entity = (ReviewIssuedEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ReviewIssuedEntity.class));
        Long id = entity.getId();
        if (id == null) {
            entity.setCreateUserName(userContext.getUserName());
            entity.setIsIssued(false);
        } else {
            entity.setUpdateUserName(userContext.getUserName());
            entity.setCreateUserName(((ReviewIssuedEntity)((Object)this.dao.getById(id))).getCreateUserName());
        }
        entity.setCompletion("\u672a\u5b8c\u6210");
        this.dao.saveOrUpdate((Object)entity, false);
        ReviewIssuedVo reviewIssuedVo = new ReviewIssuedVo();
        BeanUtil.copyProperties((Object)((Object)entity), (Object)((Object)reviewIssuedVo));
        return reviewIssuedVo;
    }

    @Override
    public List<ReviewIssuedDetailEntity> issued(List<Long> idList) {
        List settingsDetailEntityList = ((LambdaQueryChainWrapper)this.releaseUnitSettingsDetailDao.lambdaQuery().eq(ReleaseUnitSettingsDetailEntity::getType, (Object)"\u7ba1\u7406\u8bc4\u5ba1\u8f93\u5165")).list();
        if (settingsDetailEntityList.isEmpty()) {
            throw new BusinessException("\u6682\u65e0\u7ba1\u7406\u8bc4\u5ba1\u8f93\u5165\u4e0b\u8fbe\u914d\u7f6e\uff0c\u8bf7\u5148\u914d\u7f6e\uff01");
        }
        List issuedEntityList = ((LambdaQueryChainWrapper)this.dao.lambdaQuery().in(BaseEntity::getId, idList)).list();
        List releaseUnitIds = settingsDetailEntityList.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnits).collect(Collectors.toList());
        List releaseUnitName = settingsDetailEntityList.stream().map(ReleaseUnitSettingsDetailEntity::getReleaseUnitsName).collect(Collectors.toList());
        issuedEntityList.forEach(e -> {
            String releaseUnitIdsStr = StrUtil.toString((Object)releaseUnitIds).replace("[", "").replace("]", "").trim();
            e.setReleaseUnitsId(releaseUnitIdsStr);
            String releaseUnitNameStr = StrUtil.toString((Object)releaseUnitName).replace("[", "").replace("]", "").trim();
            e.setReleaseUnitsName(releaseUnitNameStr);
            e.setIsIssued(false);
        });
        this.dao.saveOrUpdateBatch(issuedEntityList);
        List saveEntityList = Lists.newArrayList();
        this.saveOrUpdateDetail(issuedEntityList, settingsDetailEntityList, saveEntityList);
        this.detailDao.saveOrUpdateBatch(saveEntityList);
        return saveEntityList;
    }

    private void saveOrUpdateDetail(List<ReviewIssuedEntity> issuedEntityList, List<ReleaseUnitSettingsDetailEntity> settingsDetailEntityList, List<ReviewIssuedDetailEntity> saveEntityList) {
        for (ReviewIssuedEntity entity : issuedEntityList) {
            for (ReleaseUnitSettingsDetailEntity unitSettingsDetailEntity : settingsDetailEntityList) {
                ReviewIssuedDetailVo reviewIssuedDetailVo = new ReviewIssuedDetailVo();
                reviewIssuedDetailVo.setTopic(entity.getTopic());
                reviewIssuedDetailVo.setContent(entity.getContent());
                reviewIssuedDetailVo.setUploadUnitId(String.valueOf(unitSettingsDetailEntity.getReleaseUnits()));
                reviewIssuedDetailVo.setUploadUnitName(unitSettingsDetailEntity.getReleaseUnitsName());
                reviewIssuedDetailVo.setCharge(unitSettingsDetailEntity.getCharge());
                reviewIssuedDetailVo.setChargeName(unitSettingsDetailEntity.getChargeName());
                reviewIssuedDetailVo.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                reviewIssuedDetailVo.setOrgId(this.sessionManager.getUserContext().getOrgId());
                reviewIssuedDetailVo.setOrgName(this.sessionManager.getUserContext().getOrgName());
                ReviewIssuedDetailEntity saveEntity = (ReviewIssuedDetailEntity)((Object)BeanMapper.map((Object)((Object)reviewIssuedDetailVo), ReviewIssuedDetailEntity.class));
                saveEntity.setIssuedId(entity.getId());
                saveEntity.setState("\u672a\u4e0a\u62a5");
                saveEntityList.add(saveEntity);
            }
        }
    }

    @Override
    public CommonResponse<Object> batchSubmit(BatchSubmitVO vo) {
        if (Objects.isNull(vo) || vo.getDetailList().isEmpty() || StrUtil.isEmpty((CharSequence)vo.getBillTypeCode())) {
            return CommonResponse.error((String)"\u6279\u91cf\u63d0\u4ea4\u5931\u8d25\uff01\u53c2\u6570\u9519\u8bef");
        }
        try {
            List<BatchSubmitVO.BatchSubmitDetailVO> detailList = vo.getDetailList();
            for (BatchSubmitVO.BatchSubmitDetailVO detail : detailList) {
                HashMap submitParam = Maps.newHashMap();
                submitParam.put("userId", InvocationInfoProxy.getUserid());
                submitParam.put("billtypeId", vo.getBillTypeCode());
                submitParam.put("businessKey", detail.getId());
                submitParam.put("formurl", this.baseHost + "/ejc-ztpczr-frontend/#/" + vo.getPath() + "/card?id=" + detail.getId());
                submitParam.put("procInstName", "\u8bc4\u5ba1\u7ba1\u7406" + detail.getId() + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
                submitParam.put("billOrgId", detail.getOrgId());
                submitParam.put("messageType", new String[]{"sys"});
                CommonResponse result = this.iBpmApi.doSubmit((Map)submitParam);
                if (result.isSuccess()) continue;
                return CommonResponse.error((String)result.getMsg());
            }
            return CommonResponse.success((String)"\u6279\u91cf\u63d0\u4ea4\u6210\u529f\uff01");
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("\u6279\u91cf\u63d0\u4ea4\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)e);
            }
            return CommonResponse.error((String)"\u6279\u91cf\u63d0\u4ea4\u5931\u8d25\uff01");
        }
    }

    @Override
    public CommonResponse<Object> del(List<Long> ids) {
        try {
            this.dao.removeByIds(ids, true);
            ((LambdaUpdateChainWrapper)this.detailDao.lambdaUpdate().in(ReviewIssuedDetailEntity::getIssuedId, ids)).remove();
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return CommonResponse.success((String)("\u5220\u9664\u5931\u8d25:" + e.getMessage()));
        }
    }

    @Override
    public ReviewIssuedVo detail(Long id, String state) {
        ReviewIssuedEntity reviewIssuedEntity = (ReviewIssuedEntity)((Object)this.dao.selectById(id));
        ReviewIssuedVo reviewIssuedVo = new ReviewIssuedVo();
        BeanUtil.copyProperties((Object)((Object)reviewIssuedEntity), (Object)((Object)reviewIssuedVo));
        if (StrUtil.isNotBlank((CharSequence)reviewIssuedEntity.getReleaseUnitsName())) {
            List strings = StrUtil.splitTrim((CharSequence)reviewIssuedEntity.getReleaseUnitsName(), (CharSequence)",");
            reviewIssuedVo.setReleaseUnitsName(strings);
            List strings1 = StrUtil.splitTrim((CharSequence)reviewIssuedEntity.getReleaseUnitsId(), (CharSequence)",");
            reviewIssuedVo.setReleaseUnitsId(strings1);
        }
        List<ReviewIssuedDetailVo> reviewIssuedDetailVoList = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(ReviewIssuedDetailEntity::getIssuedId, new Object[]{id})).list().stream().map(e -> {
            ReviewIssuedDetailVo reviewIssuedDetailVo = new ReviewIssuedDetailVo();
            BeanUtil.copyProperties((Object)e, (Object)((Object)reviewIssuedDetailVo));
            return reviewIssuedDetailVo;
        }).collect(Collectors.toList());
        if (StrUtil.isNotBlank((CharSequence)state)) {
            switch (state) {
                case "Y": {
                    reviewIssuedDetailVoList = reviewIssuedDetailVoList.stream().filter(e -> "\u5df2\u4e0a\u62a5".equals(e.getState())).collect(Collectors.toList());
                    break;
                }
                case "W": {
                    reviewIssuedDetailVoList = reviewIssuedDetailVoList.stream().filter(e -> "\u672a\u4e0a\u62a5".equals(e.getState())).collect(Collectors.toList());
                    break;
                }
            }
        }
        reviewIssuedVo.setDetailList(reviewIssuedDetailVoList);
        return reviewIssuedVo;
    }

    @Override
    public IPage<ReviewIssuedVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("topic", "releaseUnitsName", "createUserName"));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.dao.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List objects = Lists.newArrayList();
        for (ReviewIssuedEntity record : page.getRecords()) {
            ReviewIssuedVo reviewIssuedVo = new ReviewIssuedVo();
            BeanUtil.copyProperties((Object)((Object)record), (Object)((Object)reviewIssuedVo));
            if (StrUtil.isNotBlank((CharSequence)record.getReleaseUnitsName())) {
                List strings = StrUtil.splitTrim((CharSequence)record.getReleaseUnitsName(), (CharSequence)",");
                reviewIssuedVo.setReleaseUnitsName(strings);
                List strings1 = StrUtil.splitTrim((CharSequence)record.getReleaseUnitsId(), (CharSequence)",");
                reviewIssuedVo.setReleaseUnitsId(strings1);
            }
            List<ReviewIssuedDetailVo> reviewIssuedDetailVoList = ((LambdaQueryChainWrapper)this.detailDao.lambdaQuery().in(ReviewIssuedDetailEntity::getIssuedId, new Object[]{record.getId()})).list().stream().map(e -> {
                ReviewIssuedDetailVo reviewIssuedDetailVo = new ReviewIssuedDetailVo();
                BeanUtil.copyProperties((Object)e, (Object)((Object)reviewIssuedDetailVo));
                return reviewIssuedDetailVo;
            }).collect(Collectors.toList());
            reviewIssuedVo.setDetailList(reviewIssuedDetailVoList);
            objects.add(reviewIssuedVo);
        }
        pageData.setRecords(objects);
        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.dao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewIssuedExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ba1\u7406\u8bc4\u5ba1\u4e0b\u8fbe\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public ReviewIssuedServerImpl(ReviewIssuedDao dao, SessionManager sessionManager, ReviewIssuedDetailDao detailDao, ReleaseUnitSettingsDetailDao releaseUnitSettingsDetailDao, IBpmApi iBpmApi) {
        this.dao = dao;
        this.sessionManager = sessionManager;
        this.detailDao = detailDao;
        this.releaseUnitSettingsDetailDao = releaseUnitSettingsDetailDao;
        this.iBpmApi = iBpmApi;
    }
}

