package com.ejianc.business.educationtrain.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.educationtrain.bean.EducationTrainPlanDetailEntity;
/**
 * 教育培训计划主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_quality_education_train_plan")
public class EducationTrainPlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="education_train_plan_name")
    private String educationTrainPlanName; // 教育培训计划名称
    @TableField(value="plan_year")
    private Date planYear; // 计划年度
    @TableField(value="education_type_id")
    private Long educationTypeId; // 教育类型id
    @TableField(value="education_type_name")
    private String educationTypeName; // 教育类型名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="educationTrainPlanDetailService", pidName = "educationTrainPlanId")//此处有pid="xxx"，默认值pid="pid"
    private List<EducationTrainPlanDetailEntity> educationTrainPlanDetailList = new ArrayList<>(); // 教育培训计划-子实体
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getEducationTrainPlanName() {
        return educationTrainPlanName;
    }

    public void setEducationTrainPlanName(String educationTrainPlanName) {
        this.educationTrainPlanName = educationTrainPlanName;
    }
    public Date getPlanYear() {
        return planYear;
    }

    public void setPlanYear(Date planYear) {
        this.planYear = planYear;
    }
    public Long getEducationTypeId() {
        return educationTypeId;
    }

    public void setEducationTypeId(Long educationTypeId) {
        this.educationTypeId = educationTypeId;
    }
    public String getEducationTypeName() {
        return educationTypeName;
    }

    public void setEducationTypeName(String educationTypeName) {
        this.educationTypeName = educationTypeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    
    public List<EducationTrainPlanDetailEntity> getEducationTrainPlanDetailList() {
        return educationTrainPlanDetailList;
    }

    public void setEducationTrainPlanDetailList(List<EducationTrainPlanDetailEntity> educationTrainPlanDetailList) {
        this.educationTrainPlanDetailList = educationTrainPlanDetailList;
    }
}
