package com.ejianc.business.system.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.inspect.vo.SqlParam;
import com.ejianc.business.system.bean.InsuranceEntity;
import com.ejianc.business.system.service.IInsuranceService;
import com.ejianc.business.system.vo.InsuranceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 保险实体
 *
 * @author generator
 */
@Controller
@RequestMapping("insurance")
public class InsuranceController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "QUALITY_INSURANCE";

    private static final String PC_URL_PROJECT = "/ejc-quality-frontend/#/insurance/card?id=";

    @Autowired
    private IInsuranceService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IWarnCenterApi warnCenterApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InsuranceVO> saveOrUpdate(@RequestBody InsuranceVO saveOrUpdateVO) {
        InsuranceEntity entity = BeanMapper.map(saveOrUpdateVO, InsuranceEntity.class);
        if ((entity.getId() == null || entity.getId() == 0) && StringUtils.isAllBlank(saveOrUpdateVO.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        InsuranceVO vo = BeanMapper.map(entity, InsuranceVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InsuranceVO> queryDetail(Long id) {
        InsuranceEntity entity = service.selectById(id);
        InsuranceVO vo = BeanMapper.map(entity, InsuranceVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InsuranceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (InsuranceVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(InsuranceVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InsuranceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("category");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        Parameter dayNumPar = param.getParams().get("dayNum");
        if (null != dayNumPar && null != dayNumPar.getValue()) {
            String comDate = DateUtil.format(DateUtils.addDays(new Date(), (Integer) dayNumPar.getValue()), "yyyy-MM-dd");
            param.getParams().put("endDate", new Parameter(QueryParam.LE, comDate));
        }

        IPage<InsuranceEntity> page = service.queryPage(param, false);
        IPage<InsuranceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InsuranceVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("category");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InsuranceEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (InsuranceEntity entity : list) {
                entity.setBillStateName(BillStateEnum.getEnumByStateCode(entity.getBillState()).getDescription());
            }
        }

        beans.put("records", list);
        ExcelExport.getInstance().export("Insurance-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refInsuranceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InsuranceVO>> refInsuranceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InsuranceEntity> page = service.queryPage(param, false);
        IPage<InsuranceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InsuranceVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 定时预警--  保险止期前X天
     */
    @RequestMapping(value = "/insuranceEndDateWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> insuranceEndDateWarn(@RequestBody JSONObject jsonObject) {
        logger.info("接收到Task参数：{}", jsonObject);
        List<Long> ignoreTenantIds = new ArrayList<>();
        if (StringUtils.isNotBlank(jsonObject.getString("ignoreTenantIds"))) {
            ignoreTenantIds.addAll(JSONArray.parseArray(jsonObject.getString("ignoreTenantIds"), Long.class));
        }
        logger.info("忽略租户列表：{}", ignoreTenantIds);
        List<JSONObject> billParams = JSONArray.parseArray(jsonObject.getString("billParams"), JSONObject.class);
        logger.info("预警参数列表：{}", billParams);
        JSONObject defaultWarnInfo = JSON.parseObject(jsonObject.getString("defaultParam"));
        logger.info("预警默认设置：{}", defaultWarnInfo);


        CommonResponse<List<Long>> tenantResp = tenantApi.getAllValidTenantId();
        if (!tenantResp.isSuccess()) {
            logger.error("执行保险到期预警失败，获取有效的租户Id列表失败：{}", tenantResp.getMsg());
            return CommonResponse.error("执行保险到期预警失败，获取有效的租户Id列表失败！");
        }

        List<Long> tenantIds = tenantResp.getData();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行保险到期预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }
        //去掉停用的预警对应的租户Id
        tenantIds.removeAll(ignoreTenantIds);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(ignoreTenantIds) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(tenantIds)) {
            logger.error("执行保险到期预警完成，有效的租户Id列表为空！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }


        //获取租户id
        List<SqlParam> sqlParamList = new ArrayList<>();
        List<SqlParam> warnParamList = null;
        List<Long> customTenantIds = new ArrayList<>();

        for (JSONObject param : billParams) {
            warnParamList = BeanMapper.mapList(param.getJSONArray("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(param.getString("warnLevel"));
                p.setTenantId(Long.valueOf(param.getString("tenantId")));

                logger.info("获取天数：{}", p.getValue());
                sqlParamList.add(p);
            }
            customTenantIds.add(Long.valueOf(param.getString("tenantId")));
        }

        //去除自定义预警设置的对应的租户Id
        tenantIds.removeAll(customTenantIds);

        for (Long tenantId : tenantIds) {
            warnParamList = JSONArray.parseArray(defaultWarnInfo.getString("parameters"), SqlParam.class);
            for (SqlParam p : warnParamList) {
                p.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                p.setTenantId(tenantId);

                logger.info("获取天数：{}", p.getValue());
                sqlParamList.add(p);
            }
        }

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(sqlParamList)) {
            logger.error("未到设定时间，不执行该项操作！", tenantResp.getMsg());
            return sendWarnToTask(new ArrayList<>(), defaultWarnInfo.getLong("warnSetId"));
        }

        Map<Long, Integer> tenantIdMap = new HashMap<>();
        for (SqlParam param : sqlParamList) {
            if (!tenantIdMap.containsKey(param.getTenantId())) {
                tenantIdMap.put(param.getTenantId(), param.getValue().intValue());
            }
        }
        logger.info("需要查询的租户id{}", JSONObject.toJSONString(tenantIdMap));

        List<EarlyWarnTransVO> resp = new ArrayList<>();
        LambdaQueryWrapper<InsuranceEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(InsuranceEntity::getTenantId, new ArrayList<>(tenantIdMap.keySet()));
        List<InsuranceEntity> list = service.list(queryWrapper);
        for (InsuranceEntity entity : list) {
            String addDate = com.ejianc.business.util.DateUtil.addDay(new Date(), tenantIdMap.get(entity.getTenantId()));
            int days = com.ejianc.business.util.DateUtil.differentDays(entity.getEndDate(), DateUtil.parseDate(addDate));
            int days1 = com.ejianc.business.util.DateUtil.differentDays(entity.getEndDate(), new Date());
            if(days >= 0 && days1 <= 0){
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName("保险即将到期预警-" + entity.getBillCode());
                vo.setPcTitle("保险即将到期预警");
                vo.setPcUrl(PC_URL_PROJECT + entity.getId());
                vo.setOrgId(Long.valueOf(entity.getOrgId()));
                vo.setOrgName(entity.getOrgName());
                vo.setTenantId(Long.valueOf(entity.getTenantId()));
                vo.setWarnLevel(defaultWarnInfo.getString("warnLevel"));
                vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
                vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
                String tmpContent = defaultWarnInfo.getString("earlywarnContent");
                vo.setEarlywarnContent(
                        tmpContent.replaceAll("#projectName#", entity.getProjectName())
                                .replaceAll("#billCode#", entity.getBillCode() + "")
                );
                resp.add(vo);
            }
        }

        return sendWarnToTask(resp, defaultWarnInfo.getLong("warnSetId"));
    }


    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        logger.info("发送任务：{}", JSONObject.toJSONString(warnList));
        CommonResponse<String> warnResp = warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            logger.error("回调预警任务服务失败，{}", warnResp.getMsg());
            return CommonResponse.error("回调预警任务服务失败" + warnResp.getMsg());
        }
        return CommonResponse.success("任务接受处理成功！");
    }
}
