package com.ejianc.business.targetmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetmanage.vo.SecurityTeamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.targetmanage.mapper.SecurityTeamMapper;
import com.ejianc.business.targetmanage.bean.SecurityTeamEntity;
import com.ejianc.business.targetmanage.service.ISecurityTeamService;

/**
 * 安全小组主实体
 * 
 * @author generator
 * 
 */
@Service("securityTeamService")
public class SecurityTeamServiceImpl extends BaseServiceImpl<SecurityTeamMapper, SecurityTeamEntity> implements ISecurityTeamService{

    @Override
    public boolean checkSameBillCode(SecurityTeamVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<SecurityTeamEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(SecurityTeamEntity::getBillCode, vo.getBillCode());
        lambda.eq(SecurityTeamEntity::getTenantId, tenantId);
        if (null != vo.getId() && vo.getId() > 0) {
            lambda.ne(SecurityTeamEntity::getId, vo.getId());
        }
        return super.list(lambda).size() > 0;
    }
}
