package com.ejianc.business.targetmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.targetmanage.vo.YearTargetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.targetmanage.mapper.YearTargetMapper;
import com.ejianc.business.targetmanage.bean.YearTargetEntity;
import com.ejianc.business.targetmanage.service.IYearTargetService;

/**
 * 总目标年度目标主实体
 * 
 * @author generator
 * 
 */
@Service("yearTargetService")
public class YearTargetServiceImpl extends BaseServiceImpl<YearTargetMapper, YearTargetEntity> implements IYearTargetService{

    @Override
    public boolean checkSameBillCode(YearTargetVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<YearTargetEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(YearTargetEntity::getBillCode, vo.getBillCode());
        lambda.eq(YearTargetEntity::getTenantId, tenantId);
        if (null != vo.getId() && vo.getId() > 0) {
            lambda.ne(YearTargetEntity::getId, vo.getId());
        }
        return super.list(lambda).size() > 0;
    }
}
