package com.ejianc.business.urgenthandle.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.urgenthandle.vo.UrgentPlanCompileVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.urgenthandle.mapper.UrgentPlanCompileMapper;
import com.ejianc.business.urgenthandle.bean.UrgentPlanCompileEntity;
import com.ejianc.business.urgenthandle.service.IUrgentPlanCompileService;

/**
 * 应急预案汇编主实体
 * 
 * @author generator
 * 
 */
@Service("urgentPlanCompileService")
public class UrgentPlanCompileServiceImpl extends BaseServiceImpl<UrgentPlanCompileMapper, UrgentPlanCompileEntity> implements IUrgentPlanCompileService{

    @Override
    public boolean checkSameBillCode(UrgentPlanCompileVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<UrgentPlanCompileEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(UrgentPlanCompileEntity::getBillCode, vo.getBillCode());
        lambda.eq(UrgentPlanCompileEntity::getTenantId, tenantId);
        if (null != vo.getId() && vo.getId() > 0) {
            lambda.ne(UrgentPlanCompileEntity::getId, vo.getId());
        }
        return super.list(lambda).size() > 0;
    }
}
