package com.ejianc.business.quality.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.quality.dao.ReviewRefineAdviceDao;
import com.ejianc.business.quality.entity.ReviewRefineAdviceEntity;
import com.ejianc.business.quality.model.vo.ReviewRefineAdviceVo;
import com.ejianc.business.quality.service.ReviewRefineAdviceServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午9:50
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ReviewRefineAdviceServerImpl implements ReviewRefineAdviceServer {
    private final ReviewRefineAdviceDao dao;
    private final SessionManager sessionManager;

    @Override
    public ReviewRefineAdviceVo saveOrUpdate(ReviewRefineAdviceVo saveOrUpdateVO) {
        ReviewRefineAdviceEntity entity = BeanMapper.map(saveOrUpdateVO, ReviewRefineAdviceEntity.class);
        UserContext userContext = sessionManager.getUserContext();

        entity.setOrgId(userContext.getOrgId());
        entity.setOrgName(userContext.getOrgName());
        entity.setParentOrgId(userContext.getDeptId());
        entity.setParentOrgName(userContext.getDeptName());
        if (Objects.isNull(entity.getId())) {
            entity.setCreateUserName(userContext.getUserName());
            entity.setUploadUserName(userContext.getUserName());
            entity.setUploadDept(userContext.getDeptName());
        } else {
            entity.setUpdateUserName(userContext.getUserName());
            entity.setUploadDept(userContext.getDeptName());
            entity.setUploadUserName(userContext.getUserName());
            entity.setCreateUserName(dao.getById(entity.getId()).getCreateUserName());
        }
        dao.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ReviewRefineAdviceVo.class);
    }

    @Override
    public CommonResponse<Object> del(List<ReviewRefineAdviceVo> vos) {
        try {
            List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            dao.removeByIds(ids, true);
            return CommonResponse.success("删除成功！");
        } catch (Exception e) {
            return CommonResponse.success("删除失败:" + e.getMessage());
        }
    }

    @Override
    public ReviewRefineAdviceVo detail(Long id) {
        ReviewRefineAdviceEntity reviewRefineAdviceEntity = dao.selectById(id);
        return BeanMapper.map(reviewRefineAdviceEntity, ReviewRefineAdviceVo.class);
    }

    @Override
    public IPage<ReviewRefineAdviceVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("refineAdvice", "createUserName", "uploadDept"));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<ReviewRefineAdviceEntity> page = dao.queryPage(param, false);
        IPage<ReviewRefineAdviceVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReviewRefineAdviceVo.class));

        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List<ReviewRefineAdviceEntity> list = dao.lambdaQuery().in(BaseEntity::getId, ids).list();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewRefineAdviceExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("管理评审计划导出失败：" + e.getMessage());
        }
    }
}
