package com.ejianc.business.quality.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.model.vo.ReviewIssuedDetailVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/6/24 下午2:13
 * @Description: 管理评审下达明细
 */
public interface ReviewIssuedDetailServer {
    /**
     * 新增或编辑
     *
     * @param saveOrUpdateVO saveOrUpdateVO
     * @return ReviewIssuedDetailVo
     */
    ReviewIssuedDetailVo saveOrUpdate(ReviewIssuedDetailVo saveOrUpdateVO);

    /**
     * 删除
     *
     * @param vos vos
     * @return 结果
     */
    CommonResponse<Object> del(List<ReviewIssuedDetailVo> vos);

    /**
     * 详情
     *
     * @param id id
     * @return ReviewIssuedDetailVo
     */
    ReviewIssuedDetailVo detail(Long id);

    /**
     * 查询
     *
     * @param param param
     * @return IPage<ReviewIssuedDetailVo>
     */
    IPage<ReviewIssuedDetailVo> list(QueryParam param);

    /**
     * 导出
     *
     * @param ids      ids
     * @param response response
     */
    void excelExport(List<Long> ids, HttpServletResponse response);
}
