package com.ejianc.business.safety.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;


import com.ejianc.business.safety.bean.SafetySceneCheckDetailEntity;
import com.ejianc.business.safety.bean.SafetySceneCheckEntity;
import com.ejianc.business.safety.service.ISafetySceneCheckDetailService;
import com.ejianc.business.safety.service.ISafetySceneCheckService;
import com.ejianc.business.safety.service.ISafetySceneQualityCheckItemService;
import com.ejianc.business.safety.service.ISafetySceneSafetyCheckItemService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.GetAutoCode;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.vo.CheckDetailReportVO;
import com.ejianc.business.scene.vo.DangerReportVo;
import com.ejianc.business.scene.vo.NewProblemVo;
import com.ejianc.business.scene.vo.SafetySceneCheckDetailVO;
import com.ejianc.business.scene.vo.SafetySceneCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.framework.core.util.ExcelExport;


import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;




import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;


import java.util.*;

import java.util.stream.Collectors;

/**
 * 检查单主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("safetySceneCheck")
@Api(value = "检查单主表", tags = {"检查单主表"})
public class SafetySceneCheckController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SAFETY-SCENE-CHECK-DETAIL-CODE";//此处需要根据实际修改

    @Autowired
    private ISafetySceneCheckService service;

    @Autowired
    private ISafetySceneCheckDetailService detailService;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${oms.fileServerPath}")
    private String baseImgUrl;

    @Autowired
    ICommonBusinessService sceneCheck;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private ISafetySceneSafetyCheckItemService safetyCheckItemService;

    @Autowired
    private ISafetySceneQualityCheckItemService qualityCheckItemService;


    /**
     * @description: 中奥导入现场检查历史数据专用
     *
     * @param
     * @param
     * @return {@link CommonResponse< JSONObject>}
     * @author songlx
     * @date: 2023/11/23
     */
//    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
//        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
//        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
//        boolean isFailed = false;
//        MultipartFile mf = null;
//        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
//            mf = entity.getValue();
//            String originalFileName = mf.getOriginalFilename();
//            String extName = null;
//            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
//            originalFileName.replaceAll("00.", "");
//            extName = FileUtils.getFileExt(originalFileName, false);
//            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
//                isFailed = true;
//                break;
//            }
//        }
//
//        if (isFailed) {
//            return CommonResponse.error("文件格式不合法");
//        } else {
//            List<List<String>> result = ExcelReader.readExcel(mf);
//            List<SceneCheckEntity> checkList = new ArrayList<>();
//            List<SceneCheckDetailEntity> detailList = new ArrayList<>();
//            if (result != null && result.size() > 0) {
//                CommonResponse<List<ProjectRegisterVO>> listCommonResponse = projectApi.queryProjectList(20);
//                List<ProjectRegisterVO> list = listCommonResponse.getData();
//
//                LambdaQueryWrapper<SceneSafetyCheckItemEntity> safetyItemWrapper = new LambdaQueryWrapper<>();
//                safetyItemWrapper.eq(SceneSafetyCheckItemEntity::getTenantId, InvocationInfoProxy.getTenantid());
//                List<SceneSafetyCheckItemEntity> safeDocList = safetyCheckItemService.list(safetyItemWrapper);
//                Map<String, SceneSafetyCheckItemEntity> safeDocMap = safeDocList.stream().collect(Collectors.toMap(SceneSafetyCheckItemEntity::getCode, Function.identity()));
//
//                LambdaQueryWrapper<SceneQualityCheckItemEntity> squlityItemWrapper = new LambdaQueryWrapper<>();
//                squlityItemWrapper.eq(SceneQualityCheckItemEntity::getTenantId, InvocationInfoProxy.getTenantid());
//                List<SceneQualityCheckItemEntity> qualityDocList = qualityCheckItemService.list(squlityItemWrapper);
//                Map<String, SceneQualityCheckItemEntity> qualityDocMap = qualityDocList.stream().collect(Collectors.toMap(SceneQualityCheckItemEntity::getCode, Function.identity()));
//
//
//                Map<String, ProjectRegisterVO> projectMap = list.stream().collect(Collectors.toMap(ProjectRegisterVO::getName, Function.identity()));
//                String importTs = DateUtil.format(new Date(), DatePattern.PURE_DATETIME_PATTERN);
//
//                int num = 1;
//                for (int i = 0; i < result.size(); i++) {
//                    List<String> datas = result.get(i);
//                    SceneCheckEntity checkEntity = new SceneCheckEntity();
//                    checkEntity.setId(IdWorker.getId());
//                    checkEntity.setImportTs(Long.valueOf(importTs));
//                    checkEntity.setBillState(1);
//                    String formatted = String.format("%04d", num);
//                    num++;
//                    checkEntity.setBillCode("JC-" + importTs.substring(0, 6) +  formatted);
//                    String projectName = datas.get(0).trim();
//                    ProjectRegisterVO projectRegisterVO = projectMap.get(projectName);
//                    checkEntity.setOrgId(projectRegisterVO.getProjectDepartmentId());
//                    checkEntity.setOrgName(projectRegisterVO.getName());
//                    checkEntity.setProjectId(projectRegisterVO.getId());
//                    checkEntity.setProjectName(projectRegisterVO.getName());
//
//                    String checkName = datas.get(1).trim();
//                    checkEntity.setCheckName(checkName);
//
//                    String checkDateStr = datas.get(2).trim();
//                    Date checkDate = HSSFDateUtil.getJavaDate(Double.valueOf(checkDateStr));
//                    checkEntity.setCheckDate(checkDate);
//
//                    String checkTypeName = datas.get(3).trim();
//                    checkEntity.setCheckTypeName(checkTypeName);
//                    if(checkTypeName.equals("安全检查")){
//                        checkEntity.setCheckType(1448208197734875138L);
//                        checkEntity.setCheckAttr(2);
//                        checkEntity.setCheckAttrName("安全");
//                    } else {
//                        checkEntity.setCheckType(1448208377016205313L);
//                        checkEntity.setCheckAttr(1);
//                        checkEntity.setCheckAttrName("质量");
//                    }
//
//                    String checkLevel = datas.get(4).trim();
//                    checkEntity.setCheckLevel(checkLevel.equals("项目") ? 1 : 2);
//
//                    String checkPerson = datas.get(5).trim();
//                    checkEntity.setCheckPerson(checkPerson);
//
//                    String reform_duty_person = datas.get(6).trim();
//                    checkEntity.setReformDutyPerson(reform_duty_person);
//
//                    //要求完成日期
//                    String finishDateStr = datas.get(10).trim();
//                    Date finishDate = HSSFDateUtil.getJavaDate(Double.valueOf(finishDateStr));
//                    checkEntity.setFinishDate(finishDate);
//
//
//                    //子表
//                    SceneCheckDetailEntity sceneCheckDetailEntity = BeanMapper.map(checkEntity, SceneCheckDetailEntity.class);
//                    sceneCheckDetailEntity.setId(IdWorker.getId());
//                    sceneCheckDetailEntity.setPid(checkEntity.getId());
//                    sceneCheckDetailEntity.setBillCode(checkEntity.getBillCode()+ "-01");
//                    String itemCateCode = datas.get(8).trim();
//                    SceneSafetyCheckItemEntity safetyCheckItemEntity = safeDocMap.get(itemCateCode);
//                    if(safetyCheckItemEntity != null){
//                        sceneCheckDetailEntity.setCheckCategoryId(safetyCheckItemEntity.getCategoryId());
//                        sceneCheckDetailEntity.setCheckCategory(safetyCheckItemEntity.getCategoryName());
//                        sceneCheckDetailEntity.setCheckItemId(safetyCheckItemEntity.getId());
//                        sceneCheckDetailEntity.setCheckItem(safetyCheckItemEntity.getName());
//                    } else {
//                        SceneQualityCheckItemEntity qualityCheckItemEntity = qualityDocMap.get(itemCateCode);
//                        sceneCheckDetailEntity.setCheckCategoryId(qualityCheckItemEntity.getCategoryId());
//                        sceneCheckDetailEntity.setCheckCategory(qualityCheckItemEntity.getCategoryName());
//                        sceneCheckDetailEntity.setCheckItemId(qualityCheckItemEntity.getId());
//                        sceneCheckDetailEntity.setCheckItem(qualityCheckItemEntity.getName());
//                    }
//                    String danger_level = datas.get(9).trim();
//                    if("一般".equals(danger_level)){
//                        sceneCheckDetailEntity.setDangerLevel(0);
//                    } else if("严重".equals(danger_level)){
//                        sceneCheckDetailEntity.setDangerLevel(1);
//                    } else {
//                        sceneCheckDetailEntity.setDangerLevel(2);
//                    }
//
//                    // 部位
//                    String part = datas.get(11).trim();
//                    sceneCheckDetailEntity.setPart(part);
//                    // 备注
//                    String memo = datas.get(12).trim();
//                    sceneCheckDetailEntity.setMemo(memo);
//
//                    checkEntity.setReviewItem(1);
//                    // rectification_person
//                    sceneCheckDetailEntity.setRectificationPerson(reform_duty_person);
//
//
//
//                    //1、整改状态： 待整改，待复查，整改合格
//                    String taskState = "整改合格";
//
//                    //2、整改完成日期
//                    String reformDateStr = datas.get(13).trim();
//                    Date reformDate = HSSFDateUtil.getJavaDate(Double.valueOf(reformDateStr));
//                    //3、整改描述
//                    String reformMsg = datas.get(14).trim();
//
//                    //3、整改人
//                    String currentRectificationPerson = datas.get(15).trim();
//
//                    //6、复查描述
//                    String reviewDescribe = datas.get(16).trim();
//
//                    //5、复查日期
//                    String reviewDateStr = datas.get(17).trim();
//                    Date reviewDate = HSSFDateUtil.getJavaDate(Double.valueOf(reviewDateStr));
//
//                    //4、复查人
//                    String actualReviewer = datas.get(18).trim();
//
//                    checkEntity.setReviewPerson(actualReviewer);
//
//
//                    // 整改状态1-待整改，2-已整改，3-整改不合格
//                    sceneCheckDetailEntity.setTaskState(taskState);
//                    if(sceneCheckDetailEntity.getTaskState().equals("待整改")){
//                        sceneCheckDetailEntity.setBillState(0);
//                        sceneCheckDetailEntity.setIsReform(1);
//                        sceneCheckDetailEntity.setReformNumber(0);
//                        checkEntity.setReformStatus(1);
//                        checkEntity.setReviewStatus(0);
//                        sceneCheckDetailEntity.setReviewResult(0);
//                    } else if (sceneCheckDetailEntity.getTaskState().equals("待复查")) {
//                        sceneCheckDetailEntity.setBillState(1);
//                        sceneCheckDetailEntity.setIsReform(2);
//                        sceneCheckDetailEntity.setReformNumber(1);
//                        // TODO 当前整改人current_rectification_person 整改日期 整改描述
//                        sceneCheckDetailEntity.setCurrentRectificationPerson(currentRectificationPerson);
//                        sceneCheckDetailEntity.setReformDate(reformDate);
//                        checkEntity.setReformFinishDate(reformDate);
//                        sceneCheckDetailEntity.setReformMsg(reformMsg);
//                        sceneCheckDetailEntity.setReformNews(sceneCheckDetailEntity.getCurrentRectificationPerson() + "-" +DateUtil.formatDate(sceneCheckDetailEntity.getReformDate()) + "-" + Optional.ofNullable(sceneCheckDetailEntity.getReformMsg()).orElse(""));
//
//                        // TODO 复查信息 复查结果 0、待复查；1、合格；2、不合格；默认为待复查，
//                        sceneCheckDetailEntity.setReviewResult(0);
//                        sceneCheckDetailEntity.setActualReviewer(actualReviewer);
//                        sceneCheckDetailEntity.setReviewDate(reviewDate);
//                        sceneCheckDetailEntity.setReviewDescribe(null);
//                        sceneCheckDetailEntity.setReviewMsg(sceneCheckDetailEntity.getActualReviewer() + "-" +DateUtil.formatDate(sceneCheckDetailEntity.getReviewDate()) + "-" + Optional.ofNullable(sceneCheckDetailEntity.getReviewDescribe()).orElse(""));
//
//
//                        checkEntity.setReformStatus(2);
//                        checkEntity.setReviewStatus(0);
//                    } else if (sceneCheckDetailEntity.getTaskState().equals("整改合格")){
//                        sceneCheckDetailEntity.setBillState(1);
//                        sceneCheckDetailEntity.setIsReform(3);
//                        sceneCheckDetailEntity.setReformNumber(1);
//                        // TODO 当前整改人current_rectification_person 整改日期 整改描述
//                        sceneCheckDetailEntity.setCurrentRectificationPerson(currentRectificationPerson);
//                        sceneCheckDetailEntity.setReformDate(reformDate);
//                        checkEntity.setReformFinishDate(reformDate);
//                        checkEntity.setReviewedNum(1);
//                        checkEntity.setReviewPass(1);
//                        checkEntity.setReviewStatus(1);
//                        sceneCheckDetailEntity.setReformMsg(reformMsg);
//                        sceneCheckDetailEntity.setReformNews(sceneCheckDetailEntity.getCurrentRectificationPerson() + "-" +DateUtil.formatDate(sceneCheckDetailEntity.getReformDate()) + "-" + Optional.ofNullable(sceneCheckDetailEntity.getReformMsg()).orElse(""));
//
//                        // TODO 复查信息 复查结果 0、待复查；1、合格；2、不合格；默认为待复查，
//                        sceneCheckDetailEntity.setReviewResult(1);
//                        sceneCheckDetailEntity.setActualReviewer(actualReviewer);
//                        sceneCheckDetailEntity.setReviewDate(reviewDate);
//                        sceneCheckDetailEntity.setReviewDescribe(reviewDescribe);
//                        sceneCheckDetailEntity.setReviewMsg(sceneCheckDetailEntity.getActualReviewer() + "-" +DateUtil.formatDate(sceneCheckDetailEntity.getReviewDate()) + "-" + Optional.ofNullable(sceneCheckDetailEntity.getReviewDescribe()).orElse(""));
//
//
//                        checkEntity.setReformStatus(4);
//                        checkEntity.setReviewStatus(1);
//                        checkEntity.setReviewPass(1);
//                    } else if (sceneCheckDetailEntity.getTaskState().equals("整改不合格")){
//                        sceneCheckDetailEntity.setBillState(0);
//                        sceneCheckDetailEntity.setIsReform(4);
//                        sceneCheckDetailEntity.setReformNumber(1);
//                        // TODO 当前整改人current_rectification_person 整改日期 整改描述
//                        sceneCheckDetailEntity.setCurrentRectificationPerson(currentRectificationPerson);
//                        sceneCheckDetailEntity.setReformDate(reformDate);
//                        checkEntity.setReformFinishDate(reformDate);
//                        sceneCheckDetailEntity.setReformMsg(reformMsg);
//                        sceneCheckDetailEntity.setReformNews(sceneCheckDetailEntity.getCurrentRectificationPerson() + "-" +DateUtil.formatDate(sceneCheckDetailEntity.getReformDate()) + "-" + Optional.ofNullable(sceneCheckDetailEntity.getReformMsg()).orElse(""));
//
//                        // TODO 复查信息 复查结果 0、待复查；1、合格；2、不合格；默认为待复查，
//                        sceneCheckDetailEntity.setReviewResult(2);
//                        sceneCheckDetailEntity.setActualReviewer(actualReviewer);
//                        sceneCheckDetailEntity.setReviewDate(reviewDate);
//                        sceneCheckDetailEntity.setReviewDescribe(reviewDescribe);
//                        sceneCheckDetailEntity.setReviewMsg(sceneCheckDetailEntity.getActualReviewer() + "-" +DateUtil.formatDate(sceneCheckDetailEntity.getReviewDate()) + "-" + Optional.ofNullable(sceneCheckDetailEntity.getReviewDescribe()).orElse(""));
//
//
//                        checkEntity.setReformStatus(3);
//                        checkEntity.setReviewStatus(1);
//                    }
//
//
//
//                    checkList.add(checkEntity);
//                    detailList.add(sceneCheckDetailEntity);
//                }
//
//                service.saveOrUpdateBatch(checkList);
//                detailService.saveOrUpdateBatch(detailList);
//
//            }
//            return CommonResponse.success();
//        }
//    }

    @ApiOperation("测试消息")
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SafetySceneCheckVO> test(@RequestParam Long id) {
        sceneCheck.afterApprovalProcessor(id, null, null);
        return CommonResponse.success("查询详情数据成功！");
    }
    @RequestMapping(value = "/queryNewProblemReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<NewProblemVo>> queryNewProblemReport(@RequestParam String date, @RequestParam Long projectId) {
        return CommonResponse.success("查询新增问题占比表", service.queryNewProblemReport(date,projectId));
    }
    @RequestMapping(value = "/queryDangerReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<DangerReportVo>> queryDangerReport(@RequestParam String date) {
        return CommonResponse.success("查询风险识别汇总表成功", service.queryDangerReport(date));
    }
    @RequestMapping(value = "/queryProblemTopN", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryProblemTopN(@RequestParam(value = "topN",defaultValue = "5") Integer topN,@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询问题TOP5成功", service.queryProblemTopN(topN,projectId));
    }
    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SafetySceneCheckVO> saveOrUpdate(@ApiParam(name = "saveorUpdateVO", required = true) @RequestBody SafetySceneCheckVO saveorUpdateVO) {
        SafetySceneCheckEntity entity = BeanMapper.map(saveorUpdateVO, SafetySceneCheckEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());

            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //新增时整改状态设置为0
            entity.setReformStatus(Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
        }
        //获取子表
        List<SafetySceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        //子表赋值
        int count = 0;
        for (SafetySceneCheckDetailEntity sceneCheckDetail : sceneCheckDetails) {
            if (sceneCheckDetail.getRowState() == null || !"del".equals(sceneCheckDetail.getRowState())) {
                count++;
                if (StringUtils.isBlank(sceneCheckDetail.getBillCode())) {
                    sceneCheckDetail.setBillCode(entity.getBillCode() + "-" + GetAutoCode.getTowPipelineNumbers(count));
                }
            }
            //检查单名称
            if (StringUtils.isBlank(sceneCheckDetail.getCheckName())) {
                sceneCheckDetail.setCheckName(entity.getCheckName());
            }
            //项目名称
            if (StringUtils.isBlank(sceneCheckDetail.getProjectName())) {
                sceneCheckDetail.setProjectName(entity.getProjectName());
            }
            //检查项设置默认的整改标识
            if (sceneCheckDetail.getIsReform() == null) {
                sceneCheckDetail.setIsReform(Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
            }
            if (sceneCheckDetail.getCheckType() == null) {
                sceneCheckDetail.setCheckType(entity.getCheckType());
                sceneCheckDetail.setCheckTypeName(entity.getCheckTypeName());
            }
            if (sceneCheckDetail.getReformNumber() == null) {
                sceneCheckDetail.setReformNumber(0);
            }

            sceneCheckDetail.setCheckAttr(entity.getCheckAttr());
            sceneCheckDetail.setCheckAttrName(entity.getCheckAttrName());

        }
        entity.setReviewItem(count);
        service.saveOrUpdate(entity, false);

        List<SafetySceneCheckDetailEntity> sceneCheckDetails1 = entity.getSceneCheckDetails();
        List<SafetySceneCheckDetailVO> sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails1, SafetySceneCheckDetailVO.class);
        sceneCheckDetailVOList.forEach((item) -> {
            item.setBaseImgUrl(baseImgUrl);
        });
        SafetySceneCheckVO vo = BeanMapper.map(entity, SafetySceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SafetySceneCheckVO> queryDetail(@RequestParam Long id) {
        SafetySceneCheckEntity entity = service.selectById(id);
        List<SafetySceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List<SafetySceneCheckDetailVO> sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails, SafetySceneCheckDetailVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetailVOList.forEach((item) -> {
                item.setBaseImgUrl(baseImgUrl);
            });
        }
        SafetySceneCheckVO vo = BeanMapper.map(entity, SafetySceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SafetySceneCheckVO> vos) {
        service.removeByIds(vos.stream().map(SafetySceneCheckVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("检查单列表查询")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SafetySceneCheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<SafetySceneCheckEntity> page = service.queryPage(param, false);
        IPage<SafetySceneCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SafetySceneCheckVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");

        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()
                .stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SafetySceneCheckEntity> list = service.queryList(param);
        List<SafetySceneCheckVO> sceneCheckVOS = BeanMapper.mapList(list, SafetySceneCheckVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckVOS)) {
            sceneCheckVOS.forEach(t -> {
                if (t.getCheckLevel() != null) {
                    t.setCheckLevelName(1 == t.getCheckLevel().intValue() ? "项目" : "公司");
                }
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().exportWithTrans("SafetySceneCheck-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refSceneCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SafetySceneCheckVO>> refSceneCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SafetySceneCheckEntity> page = service.queryPage(param, false);
        IPage<SafetySceneCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SafetySceneCheckVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @description: 现场检查台账
     *
     * @return {@link CommonResponse< IPage< SafetySceneCheckVO>>}
     * @author songlx
     * @date: 2023/10/25
     */
    @ApiOperation("现场检查台账")
    @RequestMapping(value = "/queryCheckItemList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckDetailReportVO>> queryCheckItemList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("checkCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkItem");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId())
                .getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        IPage<CheckDetailReportVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<CheckDetailReportVO> list = service.queryCheckItemList(page, param, orgIds);
        page.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", page);
    }


    /**
     * @description: 现场检查台账- 导出
     *
     * @param param
     * @param response
     * @return
     * @author songlx
     * @date: 2023/10/25
     */
    @ApiOperation("现场检查台账- 导出")
    @RequestMapping(value = "/exportCheckItemList", method = RequestMethod.POST)
    @ResponseBody
    public void exportCheckItemList(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("checkCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkItem");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        IPage<CheckDetailReportVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<CheckDetailReportVO> list = service.queryCheckItemList(page, param, orgIds);
        Map<String, Object> beans = new HashMap<>();
        for (CheckDetailReportVO checkDetailReportVO : list){
            //质量检查类型 -- 0-质量管理行为、1-工程实体质量
            if (checkDetailReportVO.getQualityCheckType() != null && checkDetailReportVO.getQualityCheckType().equals(0)){
                checkDetailReportVO.setQualityCheckTypeName("安全管理检查");
            }
            if (checkDetailReportVO.getQualityCheckType() != null && checkDetailReportVO.getQualityCheckType().equals(1)){
                checkDetailReportVO.setQualityCheckTypeName("安全行为检查");
            }

        }
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("SafetyCheckItemList-export.xlsx", beans, response);
    }

    /**
     * @description: 移动端-现场检查数量统计
     *
     * @param param
     * @return {@link CommonResponse< JSONObject>}
     * @author songlx
     * @date: 2023/10/25
     */
    @ApiOperation("queryCheckItemCount")
    @RequestMapping(value = "/queryCheckItemCount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryCheckItemCount(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("c.tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("c.orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("c.orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        JSONObject obj = service.queryCheckItemCount(param);
        return CommonResponse.success("查询列表数据成功！", obj);
    }



    @ApiOperation("queryBoardCheckItemCount")
    @RequestMapping(value = "/queryBoardCheckItemCount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryBoardCheckItemCount(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("c.tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("c.orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("c.orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        JSONObject obj = service.queryBoardCheckItemCount(param);
        return CommonResponse.success("查询列表数据成功！", obj);
    }


    public static void main(String[] args) {
        System.out.println("2023121309".substring(2 ,8));
    }

}
