package com.ejianc.business.safety.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;

import com.ejianc.business.safety.bean.*;

import com.ejianc.business.safety.mapper.SafetySceneCheckMapper;
import com.ejianc.business.safety.service.ISafetySceneCheckService;
import com.ejianc.business.safety.service.ISafetySceneQualityCheckCategoryService;
import com.ejianc.business.safety.service.ISafetySceneSafetyCheckCategoryService;
import com.ejianc.business.safety.service.SafetyCheckMessageService;
import com.ejianc.business.scene.util.*;
import com.ejianc.business.scene.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 检查单主表
 *
 * @author generator
 */
@Service("safetySceneCheckService")
public class SafetySceneCheckServiceImpl extends BaseServiceImpl<SafetySceneCheckMapper, SafetySceneCheckEntity>
        implements ISafetySceneCheckService {

    @Autowired
    private com.ejianc.business.safety.service.ISafetySceneCheckDetailService sceneCheckDetailService;

    @Autowired
    private com.ejianc.business.safety.service.ISafetySceneCheckRecordService sceneCheckRecordService;
    @Autowired
    private SafetySceneCheckMapper safetySceneCheckMapper;
    @Autowired
    private SafetyCheckMessageService safetyCheckMessageService;
    @Autowired
    private ISafetySceneQualityCheckCategoryService sceneQualityCheckCategoryService;
    @Autowired
    private ISafetySceneSafetyCheckCategoryService sceneSafetyCheckCategoryService;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    /**
     * 检查单提交后的操作
     *
     * @param billId 检查单id
     */
    @Override
    public void checkSubmitHandle(Long billId) {

        if (billId != null) {
            SafetySceneCheckEntity sceneCheckEntity = this.selectById(billId);

            // 检查单提交后，修改复查状态为 1
            LambdaUpdateWrapper<SafetySceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SafetySceneCheckEntity::getId, billId);
            updateWrapper.set(
                    SafetySceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REFORM_STATE.getCode()));
            updateWrapper.set(
                    SafetySceneCheckEntity::getReviewItem, sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(
                    SafetySceneCheckEntity::getReviewStatus, Integer.parseInt(SubmitState.NO_SUBMITTED.getCode()));
            this.update(updateWrapper);

            // 检查单提交后 检查项状态改为待整改
            List<SafetySceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(
                    d -> {
                        LambdaUpdateWrapper<SafetySceneCheckDetailEntity> wrapper = new LambdaUpdateWrapper<>();
                        wrapper.eq(SafetySceneCheckDetailEntity::getId, d.getId());
                        wrapper.set(
                                SafetySceneCheckDetailEntity::getIsReform,
                                Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()));
                        wrapper.set(
                                SafetySceneCheckDetailEntity::getTaskState,
                                CheckItemReformState.REFORM_STATE.getDescription());
                        sceneCheckDetailService.update(wrapper);
                    });

            List<SafetySceneCheckRecordEntity> list = new ArrayList<>();
            List<SafetySceneCheckDetailEntity> sceneCheckDetaillist = sceneCheckEntity.getSceneCheckDetails();
            // 检查单提交后，生成检查信息记录
            sceneCheckDetaillist.forEach(
                    item -> {
                        SafetySceneCheckRecordEntity sceneCheckRecord = new SafetySceneCheckRecordEntity();
                        sceneCheckRecord.setPid(item.getId());
                        sceneCheckRecord.setCheckId(item.getPid());
                        // 设置操作状态
                        sceneCheckRecord.setOperationType(
                                Integer.parseInt(OperationState.CHECK_STATE.getCode()));
                        sceneCheckRecord.setReviewPerson(item.getReviewPerson());
                        sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                        sceneCheckRecord.setReviewResult(item.getReviewResult());
                        sceneCheckRecord.setImgIds(item.getProblemImgIds());
                        sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                        sceneCheckRecord.setCheckItem(item.getCheckItem());
                        sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                        sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                        list.add(sceneCheckRecord);
                    });
            sceneCheckRecordService.saveBatch(list, list.size());

            sceneCheckEntity = this.selectById(billId);
            SafetySceneCheckVO vo = BeanMapper.map(sceneCheckEntity, SafetySceneCheckVO.class);
            // 待整改检查项发 送消息
            String reformDutyId = vo.getReformDutyId();
            String notifRelevantId = vo.getNotifRelevantId();

            vo.setMsgNum(vo.getSceneCheckDetails().size());
            vo.setMsgBillCode(vo.getBillCode());
            vo.setMsgId(vo.getId());

            if (StringUtils.isNotBlank(reformDutyId)) {
                String[] reformDuty = reformDutyId.split(",");
                // 发送消息给整改人
                safetyCheckMessageService.sendMsg(vo, reformDuty, NoticeEnum.CHECK_COMMIT_PASS);
            }
            if (StringUtils.isNotBlank(notifRelevantId)) {
                String[] notifRelevant = notifRelevantId.split(",");
                // 发送消息给需要通知人员
                safetyCheckMessageService.sendMsg(vo, notifRelevant, NoticeEnum.CHECK_COMMIT_PASS_REVIEW);
            }
        }
    }

    /**
     * 检查单弃审前的操作
     *
     * @param billId
     */
    @Override
    public boolean checkRevokeBeforeHandle(Long billId) {
        boolean flag = true;
        // 检查单弃审前，查询记录表中是否有整改记录
        SafetySceneCheckEntity sceneCheckEntity = this.selectById(billId);
        QueryParam param = new QueryParam();
        param.getParams().put("checkId", new Parameter(QueryParam.EQ, sceneCheckEntity.getId()));
        param.getParams().put(
                "operationType",
                new Parameter(QueryParam.EQ, Integer.parseInt(OperationState.REFORM_STATE.getCode())));
        List<SafetySceneCheckRecordEntity> list = sceneCheckRecordService.queryList(param, false);
        if (list.size() > 0) {
            flag = false;
        }
        return flag;
    }

    /**
     * 检查单弃审后操作
     *
     * @param billId 单据id
     */
    @Override
    public void checkRevokeAfterHandle(Long billId) {
        if (billId != null) {
            SafetySceneCheckEntity sceneCheckEntity = this.selectById(billId);
            // 检查单弃审后，修改复查状态为 0
            LambdaUpdateWrapper<SafetySceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SafetySceneCheckEntity::getId, billId);
            updateWrapper.set(
                    SafetySceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
            updateWrapper.set(
                    SafetySceneCheckEntity::getReviewItem, sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(SafetySceneCheckEntity::getReviewStatus, null);
            this.update(updateWrapper);

            // 检查单弃审后 检查项状态改为默认值 0
            List<SafetySceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(
                    d -> {
                        LambdaUpdateWrapper<SafetySceneCheckDetailEntity> wrapper = new LambdaUpdateWrapper<>();
                        wrapper.eq(SafetySceneCheckDetailEntity::getId, d.getId());
                        wrapper.set(
                                SafetySceneCheckDetailEntity::getIsReform,
                                Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
                        wrapper.set(
                                SafetySceneCheckDetailEntity::getTaskState, CheckItemReformState.DEFULT_STATE.getCode());
                        sceneCheckDetailService.update(wrapper);
                    });

            // 检查单弃审后，要删除记录表中检查单的检查记录  检查单id 和 操作类型为检查
            LambdaUpdateWrapper<SafetySceneCheckRecordEntity> deleteWrapper = new LambdaUpdateWrapper<>();
            deleteWrapper.eq(SafetySceneCheckRecordEntity::getCheckId, sceneCheckEntity.getId());
            deleteWrapper.set(
                    SafetySceneCheckRecordEntity::getOperationType,
                    Integer.parseInt(OperationState.CHECK_STATE.getCode()));
            sceneCheckRecordService.remove(deleteWrapper);
        }
    }

    @Override
    public void updateSceneCheckOverdue() {
        safetySceneCheckMapper.updateSceneCheckOverdue();
    }

    @Override
    public void updateSceneCheckOverdueNumber() {
        safetySceneCheckMapper.updateSceneCheckOverdueNumber();
    }

    @Override
    public List<XcjcsssjhzVO> getXcjcsssjhz(
            List<Long> orgIds, String jcxSort, String dzgSort, String yqwzgSort) {
        return baseMapper.getXcjcsssjhz(orgIds, jcxSort, dzgSort, yqwzgSort);
    }

    /**
     * @description: 现场检查台账
     *
     * @param page
     * @param param
     * @param orgIds
     * @return {@link List< CheckDetailReportVO>}
     * @author songlx
     * @date: 2023/10/25
     */
    @Override
    public List<CheckDetailReportVO> queryCheckItemList(IPage<CheckDetailReportVO> page, QueryParam param, List<Long> orgIds) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<CheckDetailReportVO> list = baseMapper.queryCheckItemList(page, wrapper, orgIds);
        return list;
    }

    /**
     *  移动端-现场检查数量统计
     * @param param
     */
    @Override
    public JSONObject queryCheckItemCount(QueryParam param) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        return baseMapper.queryCheckItemCount(wrapper);
    }

    @Override
    public JSONObject queryBoardCheckItemCount(QueryParam param) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        return baseMapper.queryBoardCheckItemCount(wrapper);
    }

    @Override
    public List<NewProblemVo> queryNewProblemReport(String date, Long projectId) {
        Long tenantid = InvocationInfoProxy.getTenantid();
        List<NewProblemVo> newProblemVos = baseMapper.queryNewProblemReport(date, tenantid, projectId);
        ArrayList<NewProblemVo> res = new ArrayList<>();
        if (newProblemVos.size() > 0) {
            Map<Long, List<NewProblemVo>> collect = newProblemVos.stream().collect(Collectors.groupingBy(NewProblemVo::getCheckAttr));
            Long zhiLiangJianCha = Long.valueOf("1");
            Long anQuanJianCha = Long.valueOf("2");
            List<NewProblemVo> newProblemVosZhiLiang = collect.get(zhiLiangJianCha);
            List<NewProblemVo> newProblemVosAnquan = collect.get(anQuanJianCha);
            if (null != newProblemVosZhiLiang) {
                //将所有属性id收集，查询一下都是几级
                List<Long> collectZhiLiangAll = newProblemVosZhiLiang.stream().map(NewProblemVo::getCheckCategoryId).collect(Collectors.toList());
                LambdaQueryWrapper<SafetySceneQualityCheckCategoryEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
                lambdaQueryWrapper.in(SafetySceneQualityCheckCategoryEntity::getId, collectZhiLiangAll);
                List<SafetySceneQualityCheckCategoryEntity> list = sceneQualityCheckCategoryService.list(lambdaQueryWrapper);
                HashMap<Long, Long> hashMapZhiLiang = new HashMap();
                //超过三级的二级id
                List overTwoArrayList = new ArrayList();
                //超过三级的原分类id
                List oldIdList = new ArrayList();
                for (SafetySceneQualityCheckCategoryEntity sceneQualityCheckCategoryEntity : list) {
                    //大于2说明不是二级
                    if (sceneQualityCheckCategoryEntity.getInnerCode().split("\\|").length > 2) {
                        overTwoArrayList.add(sceneQualityCheckCategoryEntity.getInnerCode().split("\\|")[1]);
                        oldIdList.add(sceneQualityCheckCategoryEntity.getId());
                        hashMapZhiLiang.put(sceneQualityCheckCategoryEntity.getId()
                                , Long.valueOf(sceneQualityCheckCategoryEntity.getInnerCode().split("\\|")[1]));

                    }
                }
                if (overTwoArrayList != null && overTwoArrayList.size() > 0) {
                    //查询不是二级的数据集合
                    LambdaQueryWrapper<SafetySceneQualityCheckCategoryEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
                    lambdaQueryWrapper1.in(SafetySceneQualityCheckCategoryEntity::getId, overTwoArrayList);
                    List<SafetySceneQualityCheckCategoryEntity> list2 = sceneQualityCheckCategoryService.list(lambdaQueryWrapper1);
                    Map<Long, String> collect2 = list2.stream().collect(Collectors.toMap(SafetySceneQualityCheckCategoryEntity::getId, SafetySceneQualityCheckCategoryEntity::getName));
                    //将不是二级的名称转换为二级名称
                    for (NewProblemVo newProblemVo : newProblemVosZhiLiang) {
                        if (oldIdList.contains(newProblemVo.getCheckCategoryId())) {
                            newProblemVo.setCheckCategory(collect2.get(hashMapZhiLiang.get(newProblemVo.getCheckCategoryId())));
                            newProblemVo.setCheckCategoryId(hashMapZhiLiang.get(newProblemVo.getCheckCategoryId()));
                        }
                    }
                }
                //将数据进行合并分组
                List<NewProblemVo> result = newProblemVosZhiLiang.stream()
                        .collect(Collectors.toMap(NewProblemVo::getCheckCategoryId, a -> a, (o1, o2) -> {
                            o1.setNewNum(ComputeUtil.safeAdd(o1.getNewNum(), o2.getNewNum()));
                            o1.setUnProcessed(ComputeUtil.safeAdd(o1.getUnProcessed(), o2.getUnProcessed()));
                            return o1;
                        })).values().stream().collect(Collectors.toList());
                //当月新增总数量（质量检查）
                BigDecimal sumNumZhiLiang = result.stream().map(NewProblemVo::getNewNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                //当月未处理总数量（质量检查）
                BigDecimal sumUnProcessedZhiLiang = result.stream().map(NewProblemVo::getUnProcessed).reduce(BigDecimal.ZERO, BigDecimal::add);
                for (NewProblemVo newProblemVo : result) {
                    newProblemVo.setNewNumRatio(ComputeUtil.bigDecimalPercent(newProblemVo.getNewNum(), sumNumZhiLiang, 2) + "%");
                    newProblemVo.setUnProcessedRatio(ComputeUtil.bigDecimalPercent(newProblemVo.getUnProcessed(), sumUnProcessedZhiLiang, 2) + "%");
                }
                NewProblemVo newProblemVo = new NewProblemVo();
                newProblemVo.setCheckAttr(1l);
                newProblemVo.setNewNum(sumNumZhiLiang);
                newProblemVo.setUnProcessed(sumUnProcessedZhiLiang);
                result.add(newProblemVo);
                res.addAll(result);
            }
            if (null != newProblemVosAnquan) {
                //将所有属性id收集，查询一下都是几级
                List<Long> collectAnQuanAll = newProblemVosAnquan.stream().map(NewProblemVo::getCheckCategoryId).collect(Collectors.toList());
                LambdaQueryWrapper<SafetySceneSafetyCheckCategoryEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
                lambdaQueryWrapper.in(SafetySceneSafetyCheckCategoryEntity::getId, collectAnQuanAll);
                List<SafetySceneSafetyCheckCategoryEntity> list = sceneSafetyCheckCategoryService.list(lambdaQueryWrapper);
                HashMap<Long, Long> hashMapZhiLiang = new HashMap();
                //超过三级的二级id
                List overTwoArrayList = new ArrayList();
                //超过三级的原分类id
                List oldIdList = new ArrayList();
                for (SafetySceneSafetyCheckCategoryEntity sceneSafetyCheckCategoryEntity : list) {
                    //大于2说明不是二级
                    if (sceneSafetyCheckCategoryEntity.getInnerCode().split("\\|").length > 3) {
                        overTwoArrayList.add(sceneSafetyCheckCategoryEntity.getInnerCode().split("\\|")[2]);
                        oldIdList.add(sceneSafetyCheckCategoryEntity.getId());
                        hashMapZhiLiang.put(sceneSafetyCheckCategoryEntity.getId()
                                , Long.valueOf(sceneSafetyCheckCategoryEntity.getInnerCode().split("\\|")[2]));

                    }
                }
                if (overTwoArrayList != null && overTwoArrayList.size() > 0) {
                    //查询不是二级的数据集合
                    LambdaQueryWrapper<SafetySceneSafetyCheckCategoryEntity> lambdaQueryWrapper1 = new LambdaQueryWrapper<>();
                    lambdaQueryWrapper1.in(SafetySceneSafetyCheckCategoryEntity::getId, overTwoArrayList);
                    List<SafetySceneSafetyCheckCategoryEntity> list2 = sceneSafetyCheckCategoryService.list(lambdaQueryWrapper1);
                    Map<Long, String> collect2 = list2.stream().collect(Collectors.toMap(SafetySceneSafetyCheckCategoryEntity::getId, SafetySceneSafetyCheckCategoryEntity::getName));
                    //将不是二级的名称转换为二级名称
                    for (NewProblemVo newProblemVo : newProblemVosAnquan) {
                        if (oldIdList.contains(newProblemVo.getCheckCategoryId())) {
                            newProblemVo.setCheckCategory(collect2.get(hashMapZhiLiang.get(newProblemVo.getCheckCategoryId())));
                            newProblemVo.setCheckCategoryId(hashMapZhiLiang.get(newProblemVo.getCheckCategoryId()));
                        }
                    }
                }
                //将数据进行合并分组
                List<NewProblemVo> result = newProblemVosAnquan.stream()
                        .collect(Collectors.toMap(NewProblemVo::getCheckCategoryId, a -> a, (o1, o2) -> {
                            o1.setNewNum(ComputeUtil.safeAdd(o1.getNewNum(), o2.getNewNum()));
                            o1.setUnProcessed(ComputeUtil.safeAdd(o1.getUnProcessed(), o2.getUnProcessed()));
                            return o1;
                        })).values().stream().collect(Collectors.toList());
                //当月新增总数量（安全检查）
                BigDecimal sumNumAnQuan = result.stream().map(NewProblemVo::getNewNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                //当月未处理总数量（安全检查）
                BigDecimal sumUnProcessedAnQuan = result.stream().map(NewProblemVo::getUnProcessed).reduce(BigDecimal.ZERO, BigDecimal::add);
                for (NewProblemVo newProblemVo : collect.get(anQuanJianCha)) {
                    newProblemVo.setNewNumRatio(ComputeUtil.bigDecimalPercent(newProblemVo.getNewNum(), sumNumAnQuan, 2) + "%");
                    newProblemVo.setUnProcessedRatio(ComputeUtil.bigDecimalPercent(newProblemVo.getUnProcessed(), sumUnProcessedAnQuan, 2) + "%");
                }
                NewProblemVo newProblemVo = new NewProblemVo();
                newProblemVo.setCheckAttr(2l);
                newProblemVo.setNewNum(sumNumAnQuan);
                newProblemVo.setUnProcessed(sumUnProcessedAnQuan);

                result.add(newProblemVo);
                res.addAll(result);
            }
        }
        List<NewProblemVo> resLast = new ArrayList<>();
        if (res != null) {
            resLast = res.stream().sorted(Comparator.comparing(NewProblemVo::getCheckAttr).reversed()).collect(Collectors.toList());
        }
        return resLast;
    }

    @Override
    public List<DangerReportVo> queryDangerReport(String date) {
        Long tenantid = InvocationInfoProxy.getTenantid();
        List<DangerReportVo> dangerReportVos = baseMapper.queryDangerReport(date, tenantid);
        Map<Long, Long> collect = dangerReportVos.stream().collect(Collectors.groupingBy(DangerReportVo::getProjectId, Collectors.counting()));
        for (DangerReportVo dangerReportVo : dangerReportVos) {
            dangerReportVo.setCheckAttrName(dangerReportVo.getCheckAttrName() + "检查");
            Long projectId = dangerReportVo.getProjectId();
            if (collect.containsKey(projectId)) {
                Long aLong = collect.get(projectId);
                dangerReportVo.setRowSpan(aLong.intValue());
                collect.remove(projectId);
            } else {
                dangerReportVo.setRowSpan(0);
            }
        }
        return dangerReportVos;
    }

    @Override
    public JSONObject queryProblemTopN(Integer topN, Long projectId) {
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        List<NewProblemVo> newProblemVos = baseMapper.queryProblemTopN(projectId, orgIds);
        JSONObject result = new JSONObject();
        if (ListUtil.isNotEmpty(newProblemVos)) {
            List<JSONObject> jsonObjectList1 = new ArrayList();
            List<JSONObject> jsonObjectList2 = new ArrayList();
            //计算占比
            //所有问题汇总
            BigDecimal allProblem = newProblemVos.stream().map(NewProblemVo::getNewNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            List<NewProblemVo> problemTopList = newProblemVos.stream().limit(topN).collect(Collectors.toList());
            Integer top = 1;
            for (NewProblemVo newProblemVo : problemTopList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("top", top);
                jsonObject.put("checkCategory", newProblemVo.getCheckCategory());
                jsonObject.put("num", newProblemVo.getNewNum());
                jsonObject.put("ratio", ComputeUtil.bigDecimalPercent(newProblemVo.getNewNum(), allProblem, 2) + "%");
                if (topN > top) {
                    top++;
                }
                jsonObjectList1.add(jsonObject);
            }
            result.put("problemTotal", jsonObjectList1);
            //问题销项排序
            List<NewProblemVo> ratioList = newProblemVos.stream().sorted(Comparator.comparing(NewProblemVo::getUnProcessed).reversed()).collect(Collectors.toList());

            List<NewProblemVo> problemTopListLimit = ratioList.stream().limit(topN).collect(Collectors.toList());
            //计算问题未处理总数
            BigDecimal allUnProcessed = newProblemVos.stream().map(NewProblemVo::getUnProcessed).reduce(BigDecimal.ZERO, BigDecimal::add);
            Integer top1 = 1;
            for (NewProblemVo newProblemVo : problemTopListLimit) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("top", top1);
                jsonObject.put("checkCategory", newProblemVo.getCheckCategory());
                jsonObject.put("num", newProblemVo.getUnProcessed());
                jsonObject.put("ratio", ComputeUtil.bigDecimalPercent(newProblemVo.getUnProcessed(), allUnProcessed, 2) + "%");
                if (topN > top1) {
                    top1++;
                }
                jsonObjectList2.add(jsonObject);

            }
            result.put("unProblemRatio", jsonObjectList2);
        }
        return result;
    }

    @Override
    public JSONObject queryQualityOrSafeCount(Long projectId, String attrCode) {
        JSONObject obj = new JSONObject();
        List<Long> checkTypeIds = new ArrayList<>();
        CommonResponse<List<DefdocDetailVO>> defDocByDefId = defdocApi.getDefDocByDefId(503220284695396431L);
        if (defDocByDefId.isSuccess()) {
            List<DefdocDetailVO> ddd = defDocByDefId.getData();
            checkTypeIds = ddd.stream().filter(t -> attrCode.equals(t.getAttrCode())).map(DefdocDetailVO::getId).collect(Collectors.toList());
        } else {
            throw new BusinessException("网络异常， 查询自定义档案失败， 请稍后再试");
        }
        List<XcjcsssjhzVO> xcjcsssjhzVOS = safetySceneCheckMapper.queryQualityOrSafeCount(projectId, checkTypeIds,null);
        if (CollectionUtils.isNotEmpty(xcjcsssjhzVOS)) {
            XcjcsssjhzVO xcjcsssjhzVO = xcjcsssjhzVOS.get(0);
            obj.put("totalJcxNum", xcjcsssjhzVO.getJcxNum());
            obj.put("totalDzgNum", xcjcsssjhzVO.getDzgNum());
            obj.put("totalDangerNum", xcjcsssjhzVO.getDangerNum());
            obj.put("totalDzgScale", ComputeUtil.bigDecimalPercent(xcjcsssjhzVO.getDzgNum(), xcjcsssjhzVO.getJcxNum(), 2));
        } else {
            obj.put("totalJcxNum", BigDecimal.ZERO);
            obj.put("totalDzgNum", BigDecimal.ZERO);
            obj.put("totalDangerNum", BigDecimal.ZERO);
            obj.put("totalDzgScale", BigDecimal.ZERO);
        }

        Calendar cal = Calendar.getInstance(); //取得今天的时间
        cal.add(Calendar.MONTH, -5);
        Date time = cal.getTime();
        String startMonth = DateUtil.format(time, "yyyy-MM");
        String endMonth = DateUtil.format(new Date(), "yyyy-MM");
        List<XcjcsssjhzVO> xcjcsssjhzVOSList = safetySceneCheckMapper.queryQualityOrSafeByDate(projectId, checkTypeIds, startMonth, endMonth);
        Map<String, XcjcsssjhzVO> monthDataMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(xcjcsssjhzVOSList)) {
            monthDataMap = xcjcsssjhzVOSList.stream().collect(Collectors.toMap(XcjcsssjhzVO::getCheckMonth, Function.identity(), (e1, e2) -> e1));
        }

        List<JSONObject> dataList = new LinkedList<>();
        List<String> monthBetween = DateUtil.getMonthBetween(startMonth, endMonth);
        for (String mon : monthBetween) {
            JSONObject js = new JSONObject();
            js.put("date", mon);
            XcjcsssjhzVO xcjcsssjhzVO = monthDataMap.get(mon);
            if (xcjcsssjhzVO != null) {
                js.put("jcxNum", xcjcsssjhzVO.getJcxNum());
                js.put("dzgNum", xcjcsssjhzVO.getDzgNum());
                js.put("dangerNum", xcjcsssjhzVO.getDangerNum());
                js.put("dzgScale", ComputeUtil.bigDecimalPercent(xcjcsssjhzVO.getDzgNum(), xcjcsssjhzVO.getJcxNum(), 2));
                js.put("dangerScale", ComputeUtil.bigDecimalPercent(xcjcsssjhzVO.getDangerNum(), xcjcsssjhzVO.getJcxNum(), 2));
            } else {
                js.put("jcxNum", BigDecimal.ZERO);
                js.put("dzgNum", BigDecimal.ZERO);
                js.put("dangerNum", BigDecimal.ZERO);
                js.put("dzgScale", BigDecimal.ZERO);
                js.put("dangerScale", BigDecimal.ZERO);
            }
            dataList.add(js);
        }

        obj.put("dataList", dataList);
        return obj;
    }

    @Override
    public JSONObject queryQualityOrSafeCount4Org() {
        JSONObject obj = new JSONObject();
        List<Long> checkTypeQuaIds = new ArrayList<>();
        List<Long> checkTypeSafeIds = new ArrayList<>();
        CommonResponse<List<DefdocDetailVO>> defDocByDefId = defdocApi.getDefDocByDefId(503220284695396431L);
        if (defDocByDefId.isSuccess()) {
            List<DefdocDetailVO> ddd = defDocByDefId.getData();
            checkTypeQuaIds = ddd.stream().filter(t -> "1".equals(t.getAttrCode())).map(DefdocDetailVO::getId).collect(Collectors.toList());
            checkTypeSafeIds = ddd.stream().filter(t -> "2".equals(t.getAttrCode())).map(DefdocDetailVO::getId).collect(Collectors.toList());
        } else {
            throw new BusinessException("网络异常， 查询自定义档案失败， 请稍后再试");
        }
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        List<XcjcsssjhzVO> xcjcsssjhzVOS = safetySceneCheckMapper.queryQualityOrSafeCount(null, checkTypeQuaIds,orgIds);
        List<XcjcsssjhzVO> safeVO = safetySceneCheckMapper.queryQualityOrSafeCount(null, checkTypeSafeIds,orgIds);
        if (CollectionUtils.isNotEmpty(xcjcsssjhzVOS)) {
            XcjcsssjhzVO xcjcsssjhzVO = xcjcsssjhzVOS.get(0);
            obj.put("totalQuaJcxNum", xcjcsssjhzVO.getJcxNum());
            obj.put("totalQuaDzgNum", xcjcsssjhzVO.getDzgNum());
            obj.put("totalQuaDangerNum", xcjcsssjhzVO.getDangerNum());
            obj.put("totalQuaYqwzgNum",xcjcsssjhzVO.getYqwzgNum());
        } else {
            obj.put("totalQuaJcxNum", BigDecimal.ZERO);
            obj.put("totalQuaDzgNum", BigDecimal.ZERO);
            obj.put("totalQuaDangerNum", BigDecimal.ZERO);
            obj.put("totalQuaYqwzgNum", BigDecimal.ZERO);
        }
        if (CollectionUtils.isNotEmpty(safeVO)) {
            XcjcsssjhzVO xcjcsssjhzVO = safeVO.get(0);
            obj.put("totalSafeJcxNum", xcjcsssjhzVO.getJcxNum());
            obj.put("totalSafeDzgNum", xcjcsssjhzVO.getDzgNum());
            obj.put("totalSafeDangerNum", xcjcsssjhzVO.getDangerNum());
            obj.put("totalSafeYqwzgNum",xcjcsssjhzVO.getYqwzgNum());
        } else {
            obj.put("totalSafeJcxNum", BigDecimal.ZERO);
            obj.put("totalSafeDzgNum", BigDecimal.ZERO);
            obj.put("totalSafeDangerNum", BigDecimal.ZERO);
            obj.put("totalSafeYqwzgNum", BigDecimal.ZERO);
        }
        JSONObject jo= safetySceneCheckMapper.queryOtherDetail(orgIds);
        obj.putAll(jo);
        return obj;
    }
}
