package com.ejianc.business.safety.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.safety.bean.SafetySceneSafetyCheckItemEntity;
import com.ejianc.business.safety.mapper.SafetySceneSafetyCheckItemMapper;
import com.ejianc.business.safety.service.ISafetySceneSafetyCheckItemService;
import com.ejianc.business.scene.vo.SafetySceneSafetyCheckItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 资源管理-安全检查项表
 * 
 * @author generator
 * 
 */
@Service("safetySceneSafetyCheckItemService")
public class SafetySceneSafetyCheckItemServiceImpl extends BaseServiceImpl<SafetySceneSafetyCheckItemMapper, SafetySceneSafetyCheckItemEntity> implements ISafetySceneSafetyCheckItemService {

    @Override
    public List<SafetySceneSafetyCheckItemVO> queryListByCategoryId(List<Long> categoryIds) {
        List<SafetySceneSafetyCheckItemVO> resp = new ArrayList<>();
        QueryWrapper<SafetySceneSafetyCheckItemEntity> query = new QueryWrapper<>();
        query.in("category_id", categoryIds);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<SafetySceneSafetyCheckItemEntity> list = super.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, SafetySceneSafetyCheckItemVO.class);
        }
        return resp;
    }

    @Override
    public SafetySceneSafetyCheckItemEntity getByCode(String code) {
        QueryWrapper<SafetySceneSafetyCheckItemEntity> query = new QueryWrapper<>();
        query.in("code", code);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        return super.getOne(query);
    }
}
