package com.ejianc.business.safety.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.api.IProjectApi;


import com.ejianc.business.safety.bean.SafetySceneCheckDetailEntity;
import com.ejianc.business.safety.bean.SafetySceneCheckEntity;
import com.ejianc.business.safety.service.ISafetySceneCheckDetailService;
import com.ejianc.business.safety.service.ISafetySceneCheckService;
import com.ejianc.business.safety.service.ISafetySceneQualityCheckItemService;
import com.ejianc.business.safety.service.ISafetySceneSafetyCheckItemService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.GetAutoCode;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.vo.CheckDetailReportVO;
import com.ejianc.business.scene.vo.DangerReportVo;
import com.ejianc.business.scene.vo.NewProblemVo;
import com.ejianc.business.scene.vo.SafetySceneCheckDetailVO;
import com.ejianc.business.scene.vo.SafetySceneCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.framework.core.util.ExcelExport;


import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;




import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;


import java.util.*;

import java.util.stream.Collectors;

/**
 * 检查单主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("safetySceneCheck")
@Api(value = "检查单主表", tags = {"检查单主表"})
public class SafetySceneCheckController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SAFETY-SCENE-CHECK-DETAIL-CODE";//此处需要根据实际修改

    @Autowired
    private ISafetySceneCheckService service;

    @Autowired
    private ISafetySceneCheckDetailService detailService;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${oms.fileServerPath}")
    private String baseImgUrl;

    @Autowired
    ICommonBusinessService sceneCheck;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private ISafetySceneSafetyCheckItemService safetyCheckItemService;

    @Autowired
    private ISafetySceneQualityCheckItemService qualityCheckItemService;


    @ApiOperation("安全分析门户")
    @RequestMapping(value = "/querySafetyAnalysisPortal", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> safetyAnalysisPortal(@RequestParam(value = "id",required = false) Long projectId) {
        JSONObject js = service.queryQualityOrSafeCount(projectId, "1");
        return CommonResponse.success("查询详情数据成功！",js);
    }


    /**
     * @description: 中奥导入现场检查历史数据专用
     *
     * @param
     * @param
     * @return {@link CommonResponse< JSONObject>}
     * @author songlx
     * @date: 2023/11/23
     */

    @ApiOperation("测试消息")
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SafetySceneCheckVO> test(@RequestParam Long id) {
        sceneCheck.afterApprovalProcessor(id, null, null);
        return CommonResponse.success("查询详情数据成功！");
    }
    @RequestMapping(value = "/queryNewProblemReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<NewProblemVo>> queryNewProblemReport(@RequestParam String date, @RequestParam Long projectId) {
        return CommonResponse.success("查询新增问题占比表", service.queryNewProblemReport(date,projectId));
    }
    @RequestMapping(value = "/queryDangerReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<DangerReportVo>> queryDangerReport(@RequestParam String date) {
        return CommonResponse.success("查询风险识别汇总表成功", service.queryDangerReport(date));
    }
    @RequestMapping(value = "/queryProblemTopN", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryProblemTopN(@RequestParam(value = "topN",defaultValue = "5") Integer topN,@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询问题TOP5成功", service.queryProblemTopN(topN,projectId));
    }
    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SafetySceneCheckVO> saveOrUpdate(@ApiParam(name = "saveorUpdateVO", required = true) @RequestBody SafetySceneCheckVO saveorUpdateVO) {
        SafetySceneCheckEntity entity = BeanMapper.map(saveorUpdateVO, SafetySceneCheckEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());

            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            //新增时整改状态设置为0
            entity.setReformStatus(Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
        }
        //获取子表
        List<SafetySceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        //子表赋值
        int count = 0;
        for (SafetySceneCheckDetailEntity sceneCheckDetail : sceneCheckDetails) {
            if (sceneCheckDetail.getRowState() == null || !"del".equals(sceneCheckDetail.getRowState())) {
                count++;
                if (StringUtils.isBlank(sceneCheckDetail.getBillCode())) {
                    sceneCheckDetail.setBillCode(entity.getBillCode() + "-" + GetAutoCode.getTowPipelineNumbers(count));
                }
            }
            //检查单名称
            if (StringUtils.isBlank(sceneCheckDetail.getCheckName())) {
                sceneCheckDetail.setCheckName(entity.getCheckName());
            }
            //项目名称
            if (StringUtils.isBlank(sceneCheckDetail.getProjectName())) {
                sceneCheckDetail.setProjectName(entity.getProjectName());
            }
            //检查项设置默认的整改标识
            if (sceneCheckDetail.getIsReform() == null) {
                sceneCheckDetail.setIsReform(Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
            }
            if (sceneCheckDetail.getCheckType() == null) {
                sceneCheckDetail.setCheckType(entity.getCheckType());
                sceneCheckDetail.setCheckTypeName(entity.getCheckTypeName());
            }
            if (sceneCheckDetail.getReformNumber() == null) {
                sceneCheckDetail.setReformNumber(0);
            }


            sceneCheckDetail.setCheckAttr(entity.getCheckAttr());
            sceneCheckDetail.setCheckAttrName(entity.getCheckAttrName());

        }
        entity.setReviewItem(count);
        service.saveOrUpdate(entity, false);

        List<SafetySceneCheckDetailEntity> sceneCheckDetails1 = entity.getSceneCheckDetails();
        List<SafetySceneCheckDetailVO> sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails1, SafetySceneCheckDetailVO.class);
        sceneCheckDetailVOList.forEach((item) -> {
            item.setBaseImgUrl(baseImgUrl);
        });
        SafetySceneCheckVO vo = BeanMapper.map(entity, SafetySceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SafetySceneCheckVO> queryDetail(@RequestParam Long id) {
        SafetySceneCheckEntity entity = service.selectById(id);
        List<SafetySceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List<SafetySceneCheckDetailVO> sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails, SafetySceneCheckDetailVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetailVOList.forEach((item) -> {
                item.setBaseImgUrl(baseImgUrl);
            });
        }
        SafetySceneCheckVO vo = BeanMapper.map(entity, SafetySceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SafetySceneCheckVO> vos) {
        service.removeByIds(vos.stream().map(SafetySceneCheckVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("检查单列表查询")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SafetySceneCheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<SafetySceneCheckEntity> page = service.queryPage(param, false);
        IPage<SafetySceneCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SafetySceneCheckVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");

        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()
                .stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SafetySceneCheckEntity> list = service.queryList(param);
        List<SafetySceneCheckVO> sceneCheckVOS = BeanMapper.mapList(list, SafetySceneCheckVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckVOS)) {
            sceneCheckVOS.forEach(t -> {
                if (t.getCheckLevel() != null) {
                    t.setCheckLevelName(1 == t.getCheckLevel().intValue() ? "项目" : "公司");
                }
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().exportWithTrans("SafetySceneCheck-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refSceneCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SafetySceneCheckVO>> refSceneCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SafetySceneCheckEntity> page = service.queryPage(param, false);
        IPage<SafetySceneCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SafetySceneCheckVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @description: 现场检查台账
     *
     * @return {@link CommonResponse< IPage< SafetySceneCheckVO>>}
     * @author songlx
     * @date: 2023/10/25
     */
    @ApiOperation("现场检查台账")
    @RequestMapping(value = "/queryCheckItemList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckDetailReportVO>> queryCheckItemList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("checkCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkItem");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId())
                .getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        IPage<CheckDetailReportVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<CheckDetailReportVO> list = service.queryCheckItemList(page, param, orgIds);
        page.setRecords(list);
        return CommonResponse.success("查询列表数据成功！", page);
    }


    /**
     * @description: 现场检查台账- 导出
     *
     * @param param
     * @param response
     * @return
     * @author songlx
     * @date: 2023/10/25
     */
    @ApiOperation("现场检查台账- 导出")
    @RequestMapping(value = "/exportCheckItemList", method = RequestMethod.POST)
    @ResponseBody
    public void exportCheckItemList(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("checkCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkItem");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Long> orgIds = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        IPage<CheckDetailReportVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<CheckDetailReportVO> list = service.queryCheckItemList(page, param, orgIds);
        Map<String, Object> beans = new HashMap<>();
        for (CheckDetailReportVO checkDetailReportVO : list){
            //质量检查类型 -- 0-质量管理行为、1-工程实体质量
            if (checkDetailReportVO.getQualityCheckType() != null && checkDetailReportVO.getQualityCheckType().equals(0)){
                checkDetailReportVO.setQualityCheckTypeName("安全管理检查");
            }
            if (checkDetailReportVO.getQualityCheckType() != null && checkDetailReportVO.getQualityCheckType().equals(1)){
                checkDetailReportVO.setQualityCheckTypeName("安全行为检查");
            }

        }
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("SafetyCheckItemList-export.xlsx", beans, response);
    }

    /**
     * @description: 移动端-现场检查数量统计
     *
     * @param param
     * @return {@link CommonResponse< JSONObject>}
     * @author songlx
     * @date: 2023/10/25
     */
    @ApiOperation("queryCheckItemCount")
    @RequestMapping(value = "/queryCheckItemCount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryCheckItemCount(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("c.tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("c.orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("c.orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        JSONObject obj = service.queryCheckItemCount(param);
        return CommonResponse.success("查询列表数据成功！", obj);
    }



    @ApiOperation("queryBoardCheckItemCount")
    @RequestMapping(value = "/queryBoardCheckItemCount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryBoardCheckItemCount(@RequestBody QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("c.tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("c.orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("c.orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        JSONObject obj = service.queryBoardCheckItemCount(param);
        return CommonResponse.success("查询列表数据成功！", obj);
    }


    public static void main(String[] args) {
        System.out.println("2023121309".substring(2 ,8));
    }

}
