/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.safety.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.safety.bean.PlanMonthDetailEntity;
import com.ejianc.business.safety.bean.PlanMonthEntity;
import com.ejianc.business.safety.bean.PlanUseEntity;
import com.ejianc.business.safety.mapper.PlanMonthMapper;
import com.ejianc.business.safety.service.IPlanMonthDetailService;
import com.ejianc.business.safety.service.IPlanMonthService;
import com.ejianc.business.safety.service.IPlanUseService;
import com.ejianc.business.scene.vo.PlanMonthDetailVO;
import com.ejianc.business.scene.vo.PlanMonthUseAnalysisVO;
import com.ejianc.business.scene.vo.PlanMonthVO;
import com.ejianc.business.util.CommonUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"planMonth"})
public class PlanMonthController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "QUALITY_MONTH_PLAN";
    @Autowired
    private IPlanMonthService service;
    @Autowired
    private IPlanUseService planUseService;
    @Autowired
    private IPlanMonthDetailService planMonthDetailService;
    private static final DateTimeFormatter YEAR_MONTH_FORMATTER = DateTimeFormatter.ofPattern("yyyyMM");
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private PlanMonthMapper planMonthMapper;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanMonthVO> saveOrUpdate(@RequestBody PlanMonthVO saveOrUpdateVO) {
        List<PlanMonthDetailEntity> detailList;
        PlanMonthEntity entity = (PlanMonthEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlanMonthEntity.class));
        entity.setAccureStatus(0);
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(detailList = entity.getPlanMonthDetailList()).isEmpty()) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (PlanMonthDetailEntity sd : detailList) {
                if ("del".equals(sd.getRowState())) continue;
                if (sd.getId() == null || entity.getId() == null) {
                    sd.setId(IdWorker.getId());
                }
                idMap.put(sd.getTid(), sd.getId());
                sd.setParentId(null);
            }
            for (PlanMonthDetailEntity sd : detailList) {
                if ("del".equals(sd.getRowState()) || !StringUtils.isNotEmpty((CharSequence)sd.getTpid())) continue;
                sd.setParentId((Long)idMap.get(sd.getTpid()));
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PlanMonthVO vo = (PlanMonthVO)BeanMapper.map((Object)((Object)entity), PlanMonthVO.class);
        List detailAllList = vo.getPlanMonthDetailList();
        if (!detailList.isEmpty()) {
            for (PlanMonthDetailVO detail : detailAllList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0L ? String.valueOf(detail.getParentId()) : null);
                detail.setParentId(null != detail.getTpid() ? Long.valueOf(detail.getTpid()) : null);
            }
            vo.setPlanMonthDetailList(TreeNodeBUtil.buildTree((List)detailAllList));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanMonthVO> queryDetail(Long id) {
        PlanMonthEntity entity = (PlanMonthEntity)((Object)this.service.selectById(id));
        PlanMonthVO vo = (PlanMonthVO)BeanMapper.map((Object)((Object)entity), PlanMonthVO.class);
        List detailList = vo.getPlanMonthDetailList();
        if (!detailList.isEmpty()) {
            for (PlanMonthDetailVO detail : detailList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0L ? String.valueOf(detail.getParentId()) : null);
                detail.setParentId(null != detail.getTpid() ? Long.valueOf(detail.getTpid()) : null);
            }
            vo.setPlanMonthDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/updateDataById"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanMonthVO> updateDataById(@RequestBody PlanMonthVO saveOrUpdateVO) {
        PlanMonthEntity planMonthEntity = (PlanMonthEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
        planMonthEntity.setFinancialAccureMny(saveOrUpdateVO.getFinancialAccureMny());
        planMonthEntity.setAccureStatus(1);
        this.service.updateById((Object)planMonthEntity);
        PlanMonthVO planMonthVO = (PlanMonthVO)BeanMapper.map((Object)((Object)planMonthEntity), PlanMonthVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)planMonthVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanMonthVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PlanMonthVO planMonthVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanMonthVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanMonthVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/feeUseAnalysis"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanMonthUseAnalysisVO>> feeUseAnalysis(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", billStateList));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List planMonthVOS = BeanMapper.mapList((Iterable)page.getRecords(), PlanMonthUseAnalysisVO.class);
        this.getData(planMonthVOS);
        pageData.setRecords(planMonthVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private void getData(List<PlanMonthUseAnalysisVO> planMonthVOS) {
        if (CollectionUtils.isNotEmpty(planMonthVOS)) {
            List<Long> projectIds = planMonthVOS.stream().map(PlanMonthUseAnalysisVO::getProjectId).collect(Collectors.toList());
            List ids = planMonthVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(PlanUseEntity::getProjectId, projectIds);
            queryWrapper.in(PlanUseEntity::getBillState, new Object[]{1, 3});
            List useEntityList = this.planUseService.list((Wrapper)queryWrapper);
            Map<String, BigDecimal> numUseMap = useEntityList.stream().collect(Collectors.groupingBy(score -> score.getProjectId() + "_" + score.getMonthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(YEAR_MONTH_FORMATTER), Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getMonthUseMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            LambdaQueryWrapper queryPLanDetailWrapper = new LambdaQueryWrapper();
            queryPLanDetailWrapper.in(PlanMonthDetailEntity::getMid, ids);
            List planMonthDetailEntityList = this.planMonthDetailService.list((Wrapper)queryPLanDetailWrapper);
            Map<String, BigDecimal> numPlanDetailMap = planMonthDetailEntityList.stream().collect(Collectors.groupingBy(score -> score.getMid() + "_" + score.getName(), Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getMonthPlanDetailMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            List<PlanMonthUseAnalysisVO> planMonthUseAnalysisVOS = this.planMonthMapper.queryuseDetailMnyByProjectIds(projectIds);
            Map<String, BigDecimal> numUseDetailMap = planMonthUseAnalysisVOS.stream().collect(Collectors.groupingBy(score -> score.getProjectId() + "_" + score.getName() + "_" + score.getMonthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(YEAR_MONTH_FORMATTER), Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getUseFeeMny()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            for (PlanMonthUseAnalysisVO planMonthUseAnalysisVO : planMonthVOS) {
                String keyQtaqUseDetial;
                String keyAqscUseDetial;
                String keyAqssUseDetial;
                String keyAqsxUseDetial;
                String keyAqxcUseDetial;
                String keyAqfhypUseDetial;
                String keyAqjcUseDetial;
                String keyZdwxUseDetial;
                String keyyjjyuseDetial;
                String keyuseDetial;
                String keyUse = planMonthUseAnalysisVO.getProjectId() + "_" + planMonthUseAnalysisVO.getMonthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(YEAR_MONTH_FORMATTER);
                if (numUseMap.containsKey(keyUse)) {
                    planMonthUseAnalysisVO.setUseFeeMny(numUseMap.get(keyUse));
                }
                planMonthUseAnalysisVO.setAccureRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getUseFeeMny(), planMonthUseAnalysisVO.getFinancialAccureMny()));
                planMonthUseAnalysisVO.setUseFeeRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getUseFeeMny(), planMonthUseAnalysisVO.getPlanFeeMny()));
                String keyPlanDetial = planMonthUseAnalysisVO.getId() + "_\u5b89\u5168\u9632\u62a4\u8bbe\u65bd\u8bbe\u5907\u652f\u51fa";
                if (numPlanDetailMap.containsKey(keyPlanDetial)) {
                    planMonthUseAnalysisVO.setAqfhPLanMny(numPlanDetailMap.get(keyPlanDetial));
                }
                if (numUseDetailMap.containsKey(keyuseDetial = planMonthUseAnalysisVO.getProjectId() + "_\u5b89\u5168\u9632\u62a4\u8bbe\u65bd\u8bbe\u5907\u652f\u51fa_" + planMonthUseAnalysisVO.getMonthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(YEAR_MONTH_FORMATTER))) {
                    planMonthUseAnalysisVO.setAqfhUseMny(numUseDetailMap.get(keyuseDetial));
                }
                planMonthUseAnalysisVO.setAqfhRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqfhUseMny(), planMonthUseAnalysisVO.getAqfhPLanMny()));
                String keyyjjyPlanDetial = planMonthUseAnalysisVO.getId() + "_\u5e94\u6025\u6551\u63f4\u8bbe\u5907\u6f14\u7ec3\u652f\u51fa";
                if (numPlanDetailMap.containsKey(keyyjjyPlanDetial)) {
                    planMonthUseAnalysisVO.setYjjyPLanMny(numPlanDetailMap.get(keyyjjyPlanDetial));
                }
                if (numUseDetailMap.containsKey(keyyjjyuseDetial = planMonthUseAnalysisVO.getProjectId() + "_\u5e94\u6025\u6551\u63f4\u8bbe\u5907\u6f14\u7ec3\u652f\u51fa_" + planMonthUseAnalysisVO.getMonthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(YEAR_MONTH_FORMATTER))) {
                    planMonthUseAnalysisVO.setYjjyUseMny(numUseDetailMap.get(keyyjjyuseDetial));
                }
                planMonthUseAnalysisVO.setYjjyRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getYjjyUseMny(), planMonthUseAnalysisVO.getYjjyPLanMny()));
                String keyZdwxPlanDetial = planMonthUseAnalysisVO.getId() + "_\u91cd\u5927\u5371\u9669\u6e90\u8bc4\u4f30\u6574\u6539\u652f\u51fa";
                if (numPlanDetailMap.containsKey(keyZdwxPlanDetial)) {
                    planMonthUseAnalysisVO.setZdwxPLanMny(numPlanDetailMap.get(keyZdwxPlanDetial));
                }
                if (numUseDetailMap.containsKey(keyZdwxUseDetial = planMonthUseAnalysisVO.getProjectId() + "_\u91cd\u5927\u5371\u9669\u6e90\u8bc4\u4f30\u6574\u6539\u652f\u51fa_" + planMonthUseAnalysisVO.getMonthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(YEAR_MONTH_FORMATTER))) {
                    planMonthUseAnalysisVO.setZdwxUseMny(numUseDetailMap.get(keyZdwxUseDetial));
                }
                planMonthUseAnalysisVO.setZdwxRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getZdwxUseMny(), planMonthUseAnalysisVO.getZdwxPLanMny()));
                String keyAqjcPlanDetial = planMonthUseAnalysisVO.getId() + "_\u5b89\u5168\u68c0\u67e5\u548c\u6807\u51c6\u5316\u652f\u51fa";
                if (numPlanDetailMap.containsKey(keyAqjcPlanDetial)) {
                    planMonthUseAnalysisVO.setAqjcPLanMny(numPlanDetailMap.get(keyAqjcPlanDetial));
                }
                if (numUseDetailMap.containsKey(keyAqjcUseDetial = planMonthUseAnalysisVO.getProjectId() + "_\u5b89\u5168\u68c0\u67e5\u548c\u6807\u51c6\u5316\u652f\u51fa_" + planMonthUseAnalysisVO.getMonthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(YEAR_MONTH_FORMATTER))) {
                    planMonthUseAnalysisVO.setAqjcUseMny(numUseDetailMap.get(keyAqjcUseDetial));
                }
                planMonthUseAnalysisVO.setAqjcRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqjcUseMny(), planMonthUseAnalysisVO.getAqjcPLanMny()));
                String keyAqfhypPlanDetial = planMonthUseAnalysisVO.getId() + "_\u5b89\u5168\u9632\u62a4\u7528\u54c1\u652f\u51fa";
                if (numPlanDetailMap.containsKey(keyAqfhypPlanDetial)) {
                    planMonthUseAnalysisVO.setAqfhypPLanMny(numPlanDetailMap.get(keyAqfhypPlanDetial));
                }
                if (numUseDetailMap.containsKey(keyAqfhypUseDetial = planMonthUseAnalysisVO.getProjectId() + "_\u5b89\u5168\u9632\u62a4\u7528\u54c1\u652f\u51fa_" + planMonthUseAnalysisVO.getMonthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(YEAR_MONTH_FORMATTER))) {
                    planMonthUseAnalysisVO.setAqfhypUseMny(numUseDetailMap.get(keyAqfhypUseDetial));
                }
                planMonthUseAnalysisVO.setAqfhypRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqfhypUseMny(), planMonthUseAnalysisVO.getAqfhypPLanMny()));
                String keyAqxcPlanDetial = planMonthUseAnalysisVO.getId() + "_\u5b89\u5168\u5ba3\u4f20\u6559\u80b2\u57f9\u8bad\u652f\u51fa";
                if (numPlanDetailMap.containsKey(keyAqxcPlanDetial)) {
                    planMonthUseAnalysisVO.setAqxcPLanMny(numPlanDetailMap.get(keyAqxcPlanDetial));
                }
                if (numUseDetailMap.containsKey(keyAqxcUseDetial = planMonthUseAnalysisVO.getProjectId() + "_\u5b89\u5168\u5ba3\u4f20\u6559\u80b2\u57f9\u8bad\u652f\u51fa_" + planMonthUseAnalysisVO.getMonthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(YEAR_MONTH_FORMATTER))) {
                    planMonthUseAnalysisVO.setAqxcUseMny(numUseDetailMap.get(keyAqxcUseDetial));
                }
                planMonthUseAnalysisVO.setAqxcRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqxcUseMny(), planMonthUseAnalysisVO.getAqxcPLanMny()));
                String keyAqsxPlanDetial = planMonthUseAnalysisVO.getId() + "_\u5b89\u5168\u56db\u65b0\u6280\u672f\u5e94\u7528\u652f\u51fa";
                if (numPlanDetailMap.containsKey(keyAqsxPlanDetial)) {
                    planMonthUseAnalysisVO.setAqsxPLanMny(numPlanDetailMap.get(keyAqsxPlanDetial));
                }
                if (numUseDetailMap.containsKey(keyAqsxUseDetial = planMonthUseAnalysisVO.getProjectId() + "_\u5b89\u5168\u56db\u65b0\u6280\u672f\u5e94\u7528\u652f\u51fa_" + planMonthUseAnalysisVO.getMonthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(YEAR_MONTH_FORMATTER))) {
                    planMonthUseAnalysisVO.setAqsxUseMny(numUseDetailMap.get(keyAqsxUseDetial));
                }
                planMonthUseAnalysisVO.setAqsxRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqsxUseMny(), planMonthUseAnalysisVO.getAqsxPLanMny()));
                String keyAqssPlanDetial = planMonthUseAnalysisVO.getId() + "_\u5b89\u5168\u8bbe\u65bd\u8bbe\u5907\u68c0\u6d4b\u652f\u51fa";
                if (numPlanDetailMap.containsKey(keyAqssPlanDetial)) {
                    planMonthUseAnalysisVO.setAqssPLanMny(numPlanDetailMap.get(keyAqssPlanDetial));
                }
                if (numUseDetailMap.containsKey(keyAqssUseDetial = planMonthUseAnalysisVO.getProjectId() + "_\u5b89\u5168\u8bbe\u65bd\u8bbe\u5907\u68c0\u6d4b\u652f\u51fa_" + planMonthUseAnalysisVO.getMonthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(YEAR_MONTH_FORMATTER))) {
                    planMonthUseAnalysisVO.setAqssUseMny(numUseDetailMap.get(keyAqssUseDetial));
                }
                planMonthUseAnalysisVO.setAqssRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqssUseMny(), planMonthUseAnalysisVO.getAqssPLanMny()));
                String keyAqscPlanDetial = planMonthUseAnalysisVO.getId() + "_\u5b89\u5168\u751f\u4ea7\u8d23\u4efb\u4fdd\u9669\u652f\u51fa";
                if (numPlanDetailMap.containsKey(keyAqscPlanDetial)) {
                    planMonthUseAnalysisVO.setAqscPLanMny(numPlanDetailMap.get(keyAqscPlanDetial));
                }
                if (numUseDetailMap.containsKey(keyAqscUseDetial = planMonthUseAnalysisVO.getProjectId() + "_\u5b89\u5168\u751f\u4ea7\u8d23\u4efb\u4fdd\u9669\u652f\u51fa_" + planMonthUseAnalysisVO.getMonthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(YEAR_MONTH_FORMATTER))) {
                    planMonthUseAnalysisVO.setAqscUseMny(numUseDetailMap.get(keyAqscUseDetial));
                }
                planMonthUseAnalysisVO.setAqscRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqscUseMny(), planMonthUseAnalysisVO.getAqscPLanMny()));
                String keyQtaqPlanDetial = planMonthUseAnalysisVO.getId() + "_\u5176\u4ed6\u5b89\u5168\u76f8\u5173\u8d39\u7528\u652f\u51fa";
                if (numPlanDetailMap.containsKey(keyQtaqPlanDetial)) {
                    planMonthUseAnalysisVO.setQtaqPLanMny(numPlanDetailMap.get(keyQtaqPlanDetial));
                }
                if (numUseDetailMap.containsKey(keyQtaqUseDetial = planMonthUseAnalysisVO.getProjectId() + "_\u5176\u4ed6\u5b89\u5168\u76f8\u5173\u8d39\u7528\u652f\u51fa_" + planMonthUseAnalysisVO.getMonthDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(YEAR_MONTH_FORMATTER))) {
                    planMonthUseAnalysisVO.setQtaqUseMny(numUseDetailMap.get(keyQtaqUseDetial));
                }
                planMonthUseAnalysisVO.setQtaqRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getQtaqUseMny(), planMonthUseAnalysisVO.getQtaqPLanMny()));
            }
        }
    }

    @RequestMapping(value={"/excelExportAnalysis"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportAnalysis(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", billStateList));
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        ArrayList<PlanMonthUseAnalysisVO> sceneCheckVOS = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            sceneCheckVOS = BeanMapper.mapList((Iterable)list, PlanMonthUseAnalysisVO.class);
            this.getData(sceneCheckVOS);
        }
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().export("PlanMonthAnalysis-export.xlsx", beans, response);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        List sceneCheckVOS = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            sceneCheckVOS = BeanMapper.mapList((Iterable)list, PlanMonthVO.class);
            for (PlanMonthVO workSummaryVO : sceneCheckVOS) {
                if (workSummaryVO.getAccureRateType().equals(1)) {
                    workSummaryVO.setAccureRateTypeName("0%");
                }
                if (workSummaryVO.getAccureRateType().equals(2)) {
                    workSummaryVO.setAccureRateTypeName("1.5%");
                }
                if (workSummaryVO.getAccureRateType().equals(3)) {
                    workSummaryVO.setAccureRateTypeName("2.0%");
                }
                if (workSummaryVO.getAccureRateType().equals(4)) {
                    workSummaryVO.setAccureRateTypeName("2.5%");
                }
                if (workSummaryVO.getAccureRateType().equals(5)) {
                    workSummaryVO.setAccureRateTypeName("3.0%");
                }
                if (workSummaryVO.getAccureRateType().equals(6)) {
                    workSummaryVO.setAccureRateTypeName("3.5%");
                }
                if (workSummaryVO.getAccureRateType().equals(7)) {
                    workSummaryVO.setAccureRateTypeName("3.75%");
                }
                if (workSummaryVO.getAccureStatus().equals(0)) {
                    workSummaryVO.setAccureStatusName("\u672a\u8ba1\u63d0");
                }
                if (workSummaryVO.getAccureStatus().equals(1)) {
                    workSummaryVO.setAccureStatusName("\u5df2\u8ba1\u63d0");
                }
                workSummaryVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)workSummaryVO.getBillState()).getDescription());
            }
        }
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().export("PlanMonth-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPlanMonthData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refPlanMonthData(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("code", "asc");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            String month = _con.getString("month");
            String projectId = _con.getString("projectId");
            queryWrapper.apply("DATE_FORMAT(month_date, '%Y-%m') = '" + month + "'", new Object[0]);
            queryWrapper.eq(PlanMonthEntity::getProjectId, (Object)projectId);
            queryWrapper.in(PlanMonthEntity::getBillState, new Object[]{1, 3});
            List planYearEntityList = this.service.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)planYearEntityList)) {
                Long id = ((PlanMonthEntity)((Object)planYearEntityList.stream().findFirst().get())).getId();
                param.getParams().put("mid", new Parameter("eq", (Object)id));
            } else {
                param.getParams().put("mid", new Parameter("eq", null));
            }
        }
        List list = this.planMonthDetailService.queryList(param, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (PlanMonthDetailEntity entity : list) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("monthPlanDetailMny", entity.getMonthPlanDetailMny());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/planMonthWarn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse planMonthWarn(HttpServletRequest request) {
        return this.service.planMonthWarn(request);
    }
}

