package com.ejianc.business.safety.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.safety.bean.*;
import com.ejianc.business.safety.service.IPlanYearDetailService;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.vo.PlanYearDetailVO;
import com.ejianc.business.scene.vo.PlanYearVO;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.business.scene.vo.WorkSummaryVO;
import com.ejianc.business.settle.vo.SettleDetailVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.safety.service.IPlanYearService;

/**
 * 安全费用年度计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("planYear")
public class PlanYearController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "QUALITY_YEAR_PLAN";//此处需要根据实际修改

    @Autowired
    private IPlanYearService service;
    @Autowired
    private IPlanYearDetailService planYearDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanYearVO> saveOrUpdate(@RequestBody PlanYearVO saveOrUpdateVO) {
    	PlanYearEntity entity = BeanMapper.map(saveOrUpdateVO, PlanYearEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //设置parentID
        List<PlanYearDetailEntity> detailList = entity.getPlanYearDetailList();
        if (!detailList.isEmpty()) {
            Map<String, Long> idMap = new HashMap<>();
            for (PlanYearDetailEntity sd : detailList) {
                if (!("del").equals(sd.getRowState())){
                    if (sd.getId() == null || entity.getId() == null) {
                        sd.setId(IdWorker.getId());
                    }
                    idMap.put(sd.getTid(), sd.getId());
                    sd.setParentId(null);
                }
            }
            for (PlanYearDetailEntity sd : detailList) {
                if (!("del").equals(sd.getRowState())){
                    if (StringUtils.isNotEmpty(sd.getTpid())) {
                        sd.setParentId(idMap.get(sd.getTpid()));
                    }
                }
            }
        }
    	service.saveOrUpdate(entity, false);
    	PlanYearVO vo = BeanMapper.map(entity, PlanYearVO.class);
        List<PlanYearDetailVO> detailAllList = vo.getPlanYearDetailList();
        if (!detailList.isEmpty()) {
            for (PlanYearDetailVO detail : detailAllList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0 ? String.valueOf(detail.getParentId()) : null);
                detail.setParentId(null != detail.getTpid() ? Long.valueOf(detail.getTpid()) : null);
            }
            vo.setPlanYearDetailList(TreeNodeBUtil.buildTree(detailAllList));
        }
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanYearVO> queryDetail(Long id) {
    	PlanYearEntity entity = service.selectById(id);
    	PlanYearVO vo = BeanMapper.map(entity, PlanYearVO.class);
        List<PlanYearDetailVO> detailList = vo.getPlanYearDetailList();
        if (!detailList.isEmpty()) {
            for (PlanYearDetailVO detail : detailList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0 ? String.valueOf(detail.getParentId()) : null);
                detail.setParentId(null != detail.getTpid() ? Long.valueOf(detail.getTpid()) : null);
            }
            vo.setPlanYearDetailList(TreeNodeBUtil.buildTree(detailList));
        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanYearVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PlanYearVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PlanYearVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanYearVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectTypeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PlanYearEntity> page = service.queryPage(param,false);
        IPage<PlanYearVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanYearVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PlanYearEntity> list = service.queryList(param);
        List<PlanYearVO> sceneCheckVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            sceneCheckVOS = BeanMapper.mapList(list, PlanYearVO.class);
            for (PlanYearVO workSummaryVO : sceneCheckVOS) {
                //    private Integer accureRateType; // 计提比例类型,1-0%,2-1.5%,3-2.0%,4-2.5%,5-3.0%,6-3.5%,7-3.75%
                if (workSummaryVO.getAccureRateType().equals(1)){
                    workSummaryVO.setAccureRateTypeName("0%");
                }
                if (workSummaryVO.getAccureRateType().equals(2)){
                    workSummaryVO.setAccureRateTypeName("1.5%");
                }
                if (workSummaryVO.getAccureRateType().equals(3)){
                    workSummaryVO.setAccureRateTypeName("2.0%");
                }
                if (workSummaryVO.getAccureRateType().equals(4)){
                    workSummaryVO.setAccureRateTypeName("2.5%");
                }
                if (workSummaryVO.getAccureRateType().equals(5)){
                    workSummaryVO.setAccureRateTypeName("3.0%");
                }
                if (workSummaryVO.getAccureRateType().equals(6)){
                    workSummaryVO.setAccureRateTypeName("3.5%");
                }
                if (workSummaryVO.getAccureRateType().equals(7)){
                    workSummaryVO.setAccureRateTypeName("3.75%");
                }

                workSummaryVO.setBillStateName(BillStateEnum.getEnumByStateCode(workSummaryVO.getBillState()).getDescription());
            }

        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", sceneCheckVOS);

        //todo:字段翻译等等

        ExcelExport.getInstance().export("PlanYear-export.xlsx", beans, response);
    }





    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPlanYearData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refPlanYearData(@RequestParam(value = "searchText", required = false) String searchText,
                                                         @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getOrderMap().put("code", "asc");
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            LambdaQueryWrapper<PlanYearEntity> queryWrapper = new LambdaQueryWrapper<>();
            String year = _con.getString("year");
            String projectId = _con.getString("projectId");
            queryWrapper.apply("DATE_FORMAT(year_date, '%Y') = '" + year + "'");
            queryWrapper.eq(PlanYearEntity::getProjectId,projectId);
            queryWrapper.in(PlanYearEntity::getBillState,1,3);
            List<PlanYearEntity> planYearEntityList = service.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(planYearEntityList)){
                Long id = planYearEntityList.stream().findFirst().get().getId();
                param.getParams().put("mid", new Parameter(QueryParam.EQ, id));
            }else{
                param.getParams().put("mid", new Parameter(QueryParam.EQ, null));
            }

        }

        List<PlanYearDetailEntity> list = planYearDetailService.queryList(param, false);
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        for(PlanYearDetailEntity entity:list) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("yearPlanDetailMny", entity.getYearPlanDetailMny());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    /**
     * @Description queryDetail 根据项目id和年月查询年度计划
     */
    @RequestMapping(value = "/getPlanYearInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanYearEntity> getPlanYearInfo(Long projectId, String year) {

        LambdaQueryWrapper<PlanYearEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.apply("DATE_FORMAT(year_date, '%Y') = '" + year + "'");
        queryWrapper.eq(PlanYearEntity::getProjectId,projectId);
        queryWrapper.in(PlanYearEntity::getBillState,1,3);
        List<PlanYearEntity> useEntityList = service.list(queryWrapper);
        PlanYearEntity planYearEntity = new PlanYearEntity();
        if (CollectionUtils.isNotEmpty(useEntityList)){
            planYearEntity = useEntityList.stream().findFirst().get();
        }

        return CommonResponse.success("查询详情数据成功！",planYearEntity);
    }




}
