package com.ejianc.business.scene.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.quality.bean.QualityAcceptContentEntity;
import com.ejianc.business.quality.bean.QualityAcceptEntity;
import com.ejianc.business.quality.service.IQualityAcceptContentService;
import com.ejianc.business.quality.service.IQualityAcceptService;
import com.ejianc.business.scene.vo.PartDocDetailDataVO;
import com.ejianc.foundation.share.api.IPartApi;
import com.ejianc.foundation.share.vo.PartDocDetailVO;
import com.ejianc.foundation.share.vo.PartDocVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * TODO
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@RestController
@RequestMapping("/bi")
public class BiController {
  private final Logger logger = LoggerFactory.getLogger(this.getClass());

  @Autowired
  private IQualityAcceptService qualityAcceptService;
  @Autowired
  private IQualityAcceptContentService qualityAcceptContentService;
  @Autowired
  private IPartApi partApi;


  /**
   * @Description queryList 查询分类树
   * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
   */
  @RequestMapping(value = "/queryListTree", method = RequestMethod.GET)
  @ResponseBody
  public CommonResponse<JSONObject> queryList(Long projectId) {
    //根据项目id查询质量验收主表数据
//    Long projectId = null;

//    if(StringUtils.isNotEmpty(param.getCondition())){
//      JSONObject _con = JSONObject.parseObject(param.getCondition());
//      projectId = _con.getLong("projectId");
//    }
    if (projectId == null){
      throw new BusinessException("请先选择项目!");
    }

    LambdaQueryWrapper<QualityAcceptEntity> lambdaQueryWrapper = new LambdaQueryWrapper();
    lambdaQueryWrapper.eq(QualityAcceptEntity::getProjectId,projectId);
    lambdaQueryWrapper.in(QualityAcceptEntity::getBillState,1,3);
    List<QualityAcceptEntity> acceptEntityList = qualityAcceptService.list(lambdaQueryWrapper);
    List<PartDocDetailDataVO> listAll = new ArrayList<>();
    List<QualityAcceptContentEntity> qualityAcceptContentEntityList = new ArrayList<>();

    if (CollectionUtils.isNotEmpty(acceptEntityList)) {
      List<Long> ids = acceptEntityList.stream().map(QualityAcceptEntity::getId).collect(Collectors.toList());
      LambdaQueryWrapper<QualityAcceptContentEntity> contentEntityLambdaQueryWrapper = new LambdaQueryWrapper();
      contentEntityLambdaQueryWrapper.in(QualityAcceptContentEntity::getQualityAcceptId, ids);
      List<QualityAcceptContentEntity> qualityAcceptEntityList = qualityAcceptContentService.list(contentEntityLambdaQueryWrapper);
      qualityAcceptEntityList.sort(
              Comparator.comparing(QualityAcceptContentEntity::getCheckBatch , Comparator.reverseOrder())
                      .thenComparing(QualityAcceptContentEntity::getAcceptDate, Comparator.reverseOrder())
      );
      List<PartDocDetailDataVO> partDocDetailDataVOS = BeanMapper.mapList(qualityAcceptEntityList, PartDocDetailDataVO.class);
//      int i = 1;
//      for(PartDocDetailDataVO partDocDetailDataVO : partDocDetailDataVOS){
//
//        Date acceptDate = partDocDetailDataVO.getAcceptDate();
//        String formattedDate = DateTimeFormatter.ofPattern("yyyy-MM-dd")
//                .format(acceptDate.toInstant().atZone(ZoneId.systemDefault()));
//        partDocDetailDataVO.setAcceptStrDate(formattedDate);
//        partDocDetailDataVO.setCode(i.toString());
//        i++;
//      }

      // 处理所有元素的acceptStrDate
      for (PartDocDetailDataVO partDocDetailDataVO : partDocDetailDataVOS) {
        Date acceptDate = partDocDetailDataVO.getAcceptDate();
        String formattedDate = DateTimeFormatter.ofPattern("yyyy-MM-dd")
                .format(acceptDate.toInstant().atZone(ZoneId.systemDefault()));
        partDocDetailDataVO.setAcceptStrDate(formattedDate);
      }

// 根据parentId分组，并设置组内code从1开始递增
      Map<Long, List<PartDocDetailDataVO>> groups = partDocDetailDataVOS.stream()
              .collect(Collectors.groupingBy(PartDocDetailDataVO::getParentId));

      groups.values().forEach(group -> {
        for (int i = 0; i < group.size(); i++) {
          group.get(i).setCode(String.valueOf(i + 1));
        }
      });


      listAll.addAll(partDocDetailDataVOS);
      String result = ""; // 默认空字符串
      if (CollectionUtils.isNotEmpty(qualityAcceptEntityList)) {
        result = qualityAcceptEntityList.stream()
                .map(QualityAcceptContentEntity::getInnerCode) // 提取 innerCode
                .filter(code -> code != null && !code.trim().isEmpty()) // 过滤空值（可选）
                .collect(Collectors.joining(", ")); // 拼接字符串

        List<Long> longList = Collections.emptyList();

        if (result != null && !result.isEmpty()) {
          longList = Arrays.stream(result.split(",")) // 按逗号分割
                  .map(String::trim)                   // 去除首尾空格
                  .filter(s -> !s.isEmpty())           // 过滤空字符串
                  .map(Long::parseLong)                // 转为 Long
                  .collect(Collectors.toList());       // 收集为 List
//          List<PartDocDetailDataVO> list = qualityAcceptContentService.getList(longList);
          PartDocVO partDocVO = new PartDocVO();
          partDocVO.setIds(longList);
          CommonResponse<List<PartDocDetailVO>> partDetailListByIds = partApi.getPartDetailListByIds(partDocVO);
          if (!partDetailListByIds.isSuccess()){
           throw new BusinessException("获取分部分项详情信息失败");
          }
          List<PartDocDetailVO> partDetailListByIdsData = partDetailListByIds.getData();
          List<PartDocDetailDataVO> list = BeanMapper.mapList(partDetailListByIdsData, PartDocDetailDataVO.class);


          //查询分部分项主表数据
          List<Long> partDocIds = list.stream().filter(s -> s.getParentId() == null).map(PartDocDetailDataVO::getPartDocId).collect(Collectors.toList());
          PartDocVO partDocMVO = new PartDocVO();
          partDocMVO.setIds(partDocIds);
//          List<PartDocDetailDataVO> partDocList = qualityAcceptContentService.getPartList(partDocIds);
          CommonResponse<List<PartDocVO>> partListByIds = partApi.getPartListByIds(partDocMVO);
          if (!partListByIds.isSuccess()){
            throw new BusinessException("获取分部分项信息失败");
          }
          List<PartDocVO> partListByIdsData = partListByIds.getData();
          List<PartDocDetailDataVO> partDocList = BeanMapper.mapList(partListByIdsData, PartDocDetailDataVO.class);

          listAll.addAll(partDocList);

          for(PartDocDetailDataVO partDocDetailDataVO : list){
            if (partDocDetailDataVO.getParentId() == null){
              partDocDetailDataVO.setParentId(partDocDetailDataVO.getPartDocId());
            }

          }
          listAll.addAll(list);


        }
      }
    }

    List<Map> resultMapList = BeanMapper.mapList(listAll, Map.class);
    JSONObject jsonObject = new JSONObject();
    jsonObject.put("records", ResultAsTree.createTreeData(resultMapList));
    return CommonResponse.success("查询列表数据成功！", jsonObject);
  }




}
