package com.ejianc.business.scene.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.scene.vo.SceneQualityCheckItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scene.mapper.SceneQualityCheckItemMapper;
import com.ejianc.business.scene.bean.SceneQualityCheckItemEntity;
import com.ejianc.business.scene.service.ISceneQualityCheckItemService;

import java.util.ArrayList;
import java.util.List;

/**
 * 资源管理-质量检查项表
 * 
 * @author generator
 * 
 */
@Service("sceneQualityCheckItemService")
public class SceneQualityCheckItemServiceImpl extends BaseServiceImpl<SceneQualityCheckItemMapper, SceneQualityCheckItemEntity> implements ISceneQualityCheckItemService{

    @Override
    public List<SceneQualityCheckItemVO> queryListByCategoryId(List<Long> categoryIds) {
        List<SceneQualityCheckItemVO> resp = new ArrayList<>();
        QueryWrapper<SceneQualityCheckItemEntity> query = new QueryWrapper<>();
        query.in("category_id", categoryIds);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<SceneQualityCheckItemEntity> list = super.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, SceneQualityCheckItemVO.class);
        }
        return resp;
    }

    @Override
    public SceneQualityCheckItemEntity getByCode(String code) {
        QueryWrapper<SceneQualityCheckItemEntity> query = new QueryWrapper<>();
        query.in("code", code);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        return super.getOne(query);
    }


}
