package com.ejianc.business.safety.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.safety.bean.SafetySceneQualityCheckItemEntity;
import com.ejianc.business.safety.mapper.SafetySceneQualityCheckItemMapper;
import com.ejianc.business.safety.service.ISafetySceneQualityCheckItemService;
import com.ejianc.business.scene.vo.SafetySceneQualityCheckItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;


import java.util.ArrayList;
import java.util.List;

/**
 * 资源管理-质量检查项表
 * 
 * @author generator
 * 
 */
@Service("safetySceneQualityCheckItemService")
public class SafetySceneQualityCheckItemServiceImpl extends BaseServiceImpl<SafetySceneQualityCheckItemMapper, SafetySceneQualityCheckItemEntity> implements ISafetySceneQualityCheckItemService {

    @Override
    public List<SafetySceneQualityCheckItemVO> queryListByCategoryId(List<Long> categoryIds) {
        List<SafetySceneQualityCheckItemVO> resp = new ArrayList<>();
        QueryWrapper<SafetySceneQualityCheckItemEntity> query = new QueryWrapper<>();
        query.in("category_id", categoryIds);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<SafetySceneQualityCheckItemEntity> list = super.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, SafetySceneQualityCheckItemVO.class);
        }
        return resp;
    }

    @Override
    public SafetySceneQualityCheckItemEntity getByCode(String code) {
        QueryWrapper<SafetySceneQualityCheckItemEntity> query = new QueryWrapper<>();
        query.in("code", code);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        return super.getOne(query);
    }


}
