package com.ejianc.business.safety.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.safety.bean.PlanYearDetailEntity;
/**
 * 安全费用年度计划
 * 
 * @author generator
 * 
 */
 @TableName("ejc_safety_plan_year")
public class PlanYearEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="state")
    private Integer state; // 状态
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="employee_id")
    private Long employeeId; // 填报人id
    @TableField(value="employee_name")
    private String employeeName; // 填报人名称
    @TableField(value="employee_code")
    private String employeeCode; // 填报人编码
    @TableField(value="employee_part")
    private String employeePart; // 填报人部门
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织code
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="second_unit")
    private String secondUnit; // 二级单位
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="create_date")
    private Date createDate; // 编制日期
    @TableField(value="project_type_id")
    private Long projectTypeId; // 项目类型id
    @TableField(value="project_type_name")
    private String projectTypeName; // 项目类型name
    @TableField(value="accure_rate_type")
    private Integer accureRateType; // 计提比例类型,1-0%,2-1.5%,3-2.0%,4-2.5%,5-3.0%,6-3.5%,7-3.75%
    @TableField(value="plan_fee_mny")
    private BigDecimal planFeeMny; // 计划费用(万元)
    @TableField(value="plan_value_mny")
    private BigDecimal planValueMny; // 计划产值(万元)
    @TableField(value="accure_mny")
    private BigDecimal accureMny; // 计提金额(万元)
    @TableField(value="year_date")
    private Date yearDate; // 年度
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="planYearDetailService",pidName ="mid")//此处有pid="xxx"，默认值pid="pid"
    private List<PlanYearDetailEntity> planYearDetailList = new ArrayList<>(); // 安全费用年度计划-子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }
    public String getEmployeePart() {
        return employeePart;
    }

    public void setEmployeePart(String employeePart) {
        this.employeePart = employeePart;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getSecondUnit() {
        return secondUnit;
    }

    public void setSecondUnit(String secondUnit) {
        this.secondUnit = secondUnit;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    public Long getProjectTypeId() {
        return projectTypeId;
    }

    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public Integer getAccureRateType() {
        return accureRateType;
    }

    public void setAccureRateType(Integer accureRateType) {
        this.accureRateType = accureRateType;
    }
    public BigDecimal getPlanFeeMny() {
        return planFeeMny;
    }

    public void setPlanFeeMny(BigDecimal planFeeMny) {
        this.planFeeMny = planFeeMny;
    }
    public BigDecimal getPlanValueMny() {
        return planValueMny;
    }

    public void setPlanValueMny(BigDecimal planValueMny) {
        this.planValueMny = planValueMny;
    }
    public BigDecimal getAccureMny() {
        return accureMny;
    }

    public void setAccureMny(BigDecimal accureMny) {
        this.accureMny = accureMny;
    }
    public Date getYearDate() {
        return yearDate;
    }

    public void setYearDate(Date yearDate) {
        this.yearDate = yearDate;
    }
    
    public List<PlanYearDetailEntity> getPlanYearDetailList() {
        return planYearDetailList;
    }

    public void setPlanYearDetailList(List<PlanYearDetailEntity> planYearDetailList) {
        this.planYearDetailList = planYearDetailList;
    }
}
