package com.ejianc.foundation.report.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 对应的报表列
 * 
 * @author guoming
 *
 */
@TableName("ejc_report_column")
public class ColumnEntity extends BaseEntity {

	private static final long serialVersionUID = 5536588539705910052L;

	@TableField(value = "parent_id")
	private Long parentId; // 父Id

	@TableField(value = "table_id")
	private Long tableId; // 对应的数据表名

	@TableField(value = "type")
	private String type; // 字段类型（string，number）

	@TableField(value = "property")
	private String property; // 属性

	@TableField(value = "column_name")
	private String columnName; // 列名

	@TableField(value = "formula")
	private String formula; // 计算公式

	@TableField(value = "search_flag")
	private Integer searchFlag; // 是否支持搜索

	@TableField(value = "visible")
	private Integer visible; // 是否显示

	@TableField(value = "sequence")
	private Integer sequence; // 排序

	//数据格式话js函数
	@TableField(value = "formatter")
	private String formatter;

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public Long getTableId() {
		return tableId;
	}

	public void setTableId(Long tableId) {
		this.tableId = tableId;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getProperty() {
		return property;
	}

	public void setProperty(String property) {
		this.property = property;
	}

	public String getColumnName() {
		return columnName;
	}

	public void setColumnName(String columnName) {
		this.columnName = columnName;
	}

	public String getFormula() {
		return formula;
	}

	public void setFormula(String formula) {
		this.formula = formula;
	}

	public Integer getSearchFlag() {
		return searchFlag;
	}

	public void setSearchFlag(Integer searchFlag) {
		this.searchFlag = searchFlag;
	}

	public Integer getVisible() {
		return visible;
	}

	public void setVisible(Integer visible) {
		this.visible = visible;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public String getFormatter() {
		return formatter;
	}

	public void setFormatter(String formatter) {
		this.formatter = formatter;
	}
}
