package com.ejianc.foundation.report.controller;

import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.conn.ConnectTimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.vo.TableVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.util.JdkBase64Util;

@RestController
@RequestMapping("/tbl/")
public class TableController implements Serializable {

	private static final long serialVersionUID = 1349157131720323294L;
	
	@Value("${oms.tenantid}")
	private String OMS_TENANT;
	
	@Autowired
	private ITableService tableService;
	
	/**
	 * 新增或者修改
	 * 
	 * @param Datas
	 * @return
	 * @throws BillCodeException 
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody TableVO tableVo) {
		if(tableVo.getId() != null && tableVo.getId() > 0) {
			TableEntity uniqueBean = tableService.selectById(tableVo.getId());
			uniqueBean.setCode(tableVo.getCode());
			uniqueBean.setTableName(tableVo.getTableName());
			uniqueBean.setIndexName(tableVo.getIndexName());
			uniqueBean.setDatasetId(tableVo.getDatasetId());
			
			tableService.saveOrUpdate(uniqueBean, false);
			
			return CommonResponse.success("修改成功");
		}else{
			TableEntity saveBean = BeanMapper.map(tableVo, TableEntity.class);
			tableService.saveOrUpdate(saveBean, false);
			
			return CommonResponse.success("保存成功");
		}
	}
	
	/**
	 * 查询待分页的列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, OMS_TENANT));
		queryParam.getOrderMap().put("createTime", QueryParam.DESC);
		IPage<TableEntity> pageResult = tableService.queryPage(queryParam, false);
		
		IPage<TableVO> pageData = new Page<>();
		pageData.setCurrent(pageResult.getCurrent());
		pageData.setPages(pageResult.getPages());
		pageData.setSize(pageResult.getSize());
		pageData.setTotal(pageResult.getTotal());
		pageData.setRecords(BeanMapper.mapList(pageResult.getRecords(), TableVO.class));
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", pageData);
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 根据主键ID查询详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<TableVO> queryDetail(@RequestParam Long id) {
		TableEntity tableEntity = tableService.selectById(id);
		if(tableEntity != null) {
			TableVO tableVo = BeanMapper.map(tableEntity, TableVO.class);
			return CommonResponse.success(tableVo);
		}
		return null;
	}
	
	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		tableService.deleteByIds(ids);
		return CommonResponse.success("删除成功");
	}
	
	@RequestMapping(value = "/test")
	@ResponseBody
	public CommonResponse<String> test() throws ConnectTimeoutException, SocketTimeoutException, Exception {
		String url = "http://127.0.0.1:8081/ejc-idm-web/common/report/parse";
		JSONObject paramJson = new JSONObject();
		paramJson.put("sqlContent", JdkBase64Util.encode("select id,user_code,user_name from ejc_idm_user where user_code=#{userCode}"));
		paramJson.put("datasetType", "1");
		
		Map<String, Object> params = new HashMap<>();
		params.put("userCode", "guoming");
		paramJson.put("params", params);
		
		String response = ReferHttpClientUtils.postByJson(url, JSON.toJSONString(paramJson));
		
		System.out.println(response);
		return CommonResponse.success("执行成功");
	}
}
