package com.ejianc.foundation.report.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.mapper.ColumnMapper;
import com.ejianc.foundation.report.mapper.TableMapper;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class TableServiceImpl extends BaseServiceImpl<TableMapper, TableEntity> implements ITableService {

	@Autowired
	private TableMapper tableMapper;
	@Autowired
	private ColumnMapper columnMapper;
	
	@Override
	public void deleteByIds(List<Long> ids) {
		if(ids != null && ids.size() > 0) {
			for(Long id:ids) {
				QueryWrapper<ColumnEntity> columnWrapper = new QueryWrapper<>();
				columnWrapper.eq("table_id", id);
				List<ColumnEntity> columnEntities = columnMapper.selectList(columnWrapper);
				if(columnEntities != null && columnEntities.size() > 0) {
					throw new BusinessException("要删除的库中已经有列配置了， 不允许删除");
				}
				tableMapper.deleteById(id);
			}
		}
	}

}
