package com.ejianc.foundation.report.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.report.bean.DatasetEntity;
import com.ejianc.foundation.report.service.IDatasetService;
import com.ejianc.foundation.report.vo.DatasetVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@RestController
@RequestMapping("/dataset/")
public class DatasetController implements Serializable {

	private static final long serialVersionUID = 7563509787599976846L;
	
    @Value("${common.env.base-host}")
    private String baseHost;

	@Value("${oms.tenantid}")
	private String OMS_TENANT;
	
	@Autowired
	private IDatasetService datasetService;
	
	/**
	 * 新增或者修改
	 * 
	 * @param Datas
	 * @return
	 * @throws BillCodeException 
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdate(@RequestBody DatasetVO datasetVo) {
		if(datasetVo.getId() != null && datasetVo.getId() > 0) {
			DatasetEntity uniqueBean = datasetService.selectById(datasetVo.getId());
			uniqueBean.setMdProjectId(datasetVo.getMdProjectId());
			uniqueBean.setCode(datasetVo.getCode());
			uniqueBean.setName(datasetVo.getName());
			uniqueBean.setSqlContent(datasetVo.getSqlContent());
			uniqueBean.setChildParam(datasetVo.getChildParam());
			uniqueBean.setSequence(datasetVo.getSequence());
			
			datasetService.saveOrUpdate(uniqueBean, false);
			
			return CommonResponse.success("修改成功");
		} else {
			DatasetEntity saveBean = BeanMapper.map(datasetVo, DatasetEntity.class);
			
			datasetService.saveOrUpdate(saveBean, false);
			
			return CommonResponse.success("保存成功");
		}
	}
	
	/**
	 * 查询待分页的列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, OMS_TENANT));
		queryParam.getOrderMap().put("sequence", QueryParam.ASC);
		IPage<DatasetEntity> pageData = datasetService.queryPage(queryParam);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("data", pageData);
		return CommonResponse.success(jsonObject);
	}
	
	/**
	 * 根据主键ID查询详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<DatasetVO> queryDetail(@RequestParam Long id) {
		DatasetEntity datasetEntity = datasetService.selectById(id);
		if(datasetEntity != null) {
			DatasetVO datasetVo = BeanMapper.map(datasetEntity, DatasetVO.class);
			return CommonResponse.success(datasetVo);
		}
		return null;
	}
	
	/**
	 * 删除
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<Long> ids) {
		datasetService.deleteByIds(ids);
		return CommonResponse.success("删除成功");
	}
	
	@RequestMapping(value = "refDatasetPage", method = RequestMethod.GET)
	@ResponseBody
    public CommonResponse<IPage<DatasetVO>> refDatasetPage(
		@RequestParam(defaultValue = "1") int pageNumber,
		@RequestParam(defaultValue = "10") int pageSize,
		@RequestParam(required=false) String relyCondition,
		@RequestParam(required=false) String searchText,
		@RequestParam(required=false) String condition,
		@RequestParam(required=false) String searchObject
		) {
    	QueryParam queryParam = new QueryParam();
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, OMS_TENANT));
		queryParam.getOrderMap().put("sequence", QueryParam.ASC);
		
		IPage<DatasetVO> voPage = null;
		IPage<DatasetEntity> pageData = datasetService.queryPage(queryParam);
        if(pageData!=null){
            voPage = new Page<>();
            voPage.setCurrent(pageData.getCurrent());
            voPage.setPages(pageData.getPages());
            voPage.setTotal(pageData.getTotal());
            voPage.setSize(queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList(pageData.getRecords(),DatasetVO.class));
        }
        return CommonResponse.success("查询成功！", voPage);
    }

    /**
	 * 组织-用户参照元数据
	 * 
	 * @param refCode
	 * @return
	 */
	@RequestMapping(value = "/findByCode", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
		ReferVO refer = new ReferVO();
		List<ReferShowfieldVO> gridHeaders = new ArrayList<>();
		switch(refCode){
			case "dataset":
				refer.setRefCode("dataset");
				refer.setRefName("数据集");
				refer.setRefType("grid");
				refer.setDataurl(baseHost+"ejc-report-web/dataset/refDatasetPage");
//				refer.setDataurl("http://127.0.0.1:8080/"+"ejc-report-web/dataset/refDatasetPage");
				refer.setIdField("id");
				refer.setCodeField("code");
				refer.setNameField("name");
				refer.setId(new Date().getTime());
				refer.setInnerFilter(true);
				refer.setInnerFilterColumns("code,name");
				
				ReferShowfieldVO idHeader = new ReferShowfieldVO();
				idHeader.setId((long) 1);
				idHeader.setName("主键");
				idHeader.setCode("id");
				idHeader.setHidden(true);
				idHeader.setShowOrder("1");
				idHeader.setType("string");
				gridHeaders.add(idHeader);

				ReferShowfieldVO codeHeader = new ReferShowfieldVO();
				codeHeader.setId((long) 2);
				codeHeader.setName("数据集编码");
				codeHeader.setCode("code");
				codeHeader.setHidden(false);
				codeHeader.setShowOrder("2");
				codeHeader.setType("string");
				gridHeaders.add(codeHeader);

				ReferShowfieldVO nameHeader = new ReferShowfieldVO();
				nameHeader.setId((long) 3);
				nameHeader.setName("数据集名称");
				nameHeader.setCode("name");
				nameHeader.setHidden(false);
				nameHeader.setShowOrder("3");
				nameHeader.setType("string");
				gridHeaders.add(nameHeader);

				ReferShowfieldVO urlHeader = new ReferShowfieldVO();
				urlHeader.setId((long) 4);
				urlHeader.setName("服务地址");
				urlHeader.setCode("url");
				urlHeader.setHidden(false);
				urlHeader.setShowOrder("4");
				urlHeader.setType("string");
				gridHeaders.add(urlHeader);
				
				refer.setGridheaders(gridHeaders);
				break;
		}
		
		return CommonResponse.success(refer);
	}
	
}
