package com.ejianc.foundation.report.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.report.bean.ConditionEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.mapper.ConditionMapper;
import com.ejianc.foundation.report.service.IConditionService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author CJ
 * @Description:
 * @date 2020/10/28 10:04
 */
@Service("conditionService")
public class ConditionServiceImpl extends BaseServiceImpl<ConditionMapper, ConditionEntity> implements IConditionService {

    @Autowired
    private ITableService tableService;

    @Autowired
    private ConditionMapper mapper;

    @Override
    @Transactional
    public void saveConditions(String data) {
        JSONObject json = JSONObject.parseObject(data);
        List<ConditionEntity> entities = JSONArray.parseArray(json.getString("conditions"), ConditionEntity.class);
        Long tblId = json.getLong("tblId");
        String filterItemJson = json.getString("filterItemJson");

        List<Long> delList = new ArrayList<>();
        List<ConditionEntity> newchilds = new ArrayList<>();
        Map<String, ConditionEntity> eMap = new HashMap<>();
        for(Iterator<ConditionEntity> it = entities.iterator(); it.hasNext();) {
            ConditionEntity e = it.next();
            if(null != e.getDr() && (1 == e.getDr())) {
                delList.add(e.getId());
                it.remove();
                continue;
            }

            if((null == e.getId() && ((null == e.getParentId()) && StringUtils.isNotBlank(e.getParentRowId())))) {
                newchilds.add(e);
            } else if(StringUtils.isNotBlank(e.getRowId())) {
                eMap.put(e.getRowId(), e);
            }
            if(null == e.getId()) {
                e.setId(IdWorker.getId());
            }
        }

        if(CollectionUtil.isNotEmpty(entities)) {
            if(CollectionUtil.isNotEmpty(newchilds)) {
                newchilds.forEach(e -> {
                    if(null == e.getParentId() && StringUtils.isNotBlank(e.getParentRowId())) {
                        e.setParentId(eMap.get(e.getParentRowId()).getId().toString());
                    }
                });
            }
            this.saveOrUpdateBatch(entities);
        }

        if(CollectionUtil.isNotEmpty(delList)) {
            mapper.delByIds(delList, delList.size());
        }

        //更新报表筛选条件
        TableEntity table = tableService.getById(tblId);

        if(!StringUtils.equals(filterItemJson, table.getConditionJson())) {
            table.setConditionJson(filterItemJson);
            tableService.saveOrUpdate(table);
        }

    }
}
