/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.report.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.report.bean.ColumnEntity;
import com.ejianc.foundation.report.bean.CustomColumnEntity;
import com.ejianc.foundation.report.bean.TableEntity;
import com.ejianc.foundation.report.service.IColumnService;
import com.ejianc.foundation.report.service.ICustomColumnService;
import com.ejianc.foundation.report.service.ITableService;
import com.ejianc.foundation.report.util.CalculatorUtils;
import com.ejianc.foundation.report.util.PinYinUtil;
import com.ejianc.foundation.report.vo.ColumnVO;
import com.ejianc.foundation.report.vo.CustomColumnVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/col/"})
public class ColumnController
implements Serializable {
    private static final long serialVersionUID = 880340424115528835L;
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private IColumnService columnService;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private ITableService tableService;
    @Autowired
    private RestHighLevelClient client;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody ColumnVO columnVo) {
        QueryWrapper queryWrapper;
        List<ColumnEntity> columnList;
        TableEntity tableEntity = (TableEntity)((Object)this.tableService.getById(columnVo.getTableId()));
        if (StringUtils.isNotBlank((CharSequence)columnVo.getProperty())) {
            try {
                XContentBuilder mapping = null;
                switch (columnVo.getType()) {
                    case "string": {
                        mapping = XContentFactory.jsonBuilder().startObject().startObject(tableEntity.getIndexName()).startObject("properties").startObject(columnVo.getProperty()).field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject().endObject().endObject().endObject();
                        break;
                    }
                    case "number": {
                        mapping = XContentFactory.jsonBuilder().startObject().startObject(tableEntity.getIndexName()).startObject("properties").startObject(columnVo.getProperty()).field("type", "long").endObject().endObject().endObject().endObject();
                        break;
                    }
                    case "time": {
                        mapping = XContentFactory.jsonBuilder().startObject().startObject(tableEntity.getIndexName()).startObject("properties").startObject(columnVo.getProperty()).field("type", "date").field("format", "yyyy-MM-dd HH:mm:ss").endObject().endObject().endObject().endObject();
                    }
                }
                PutMappingRequest mappingRequest = Requests.putMappingRequest((String[])new String[]{tableEntity.getIndexName()}).type(tableEntity.getIndexName()).source(mapping);
                this.client.indices().putMapping(mappingRequest, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (columnVo.getId() != null && columnVo.getId() > 0L) {
            ColumnEntity uniqueBean = (ColumnEntity)((Object)this.columnService.selectById(columnVo.getId()));
            uniqueBean.setType(columnVo.getType());
            uniqueBean.setColumnName(columnVo.getColumnName());
            if (StringUtils.isNotBlank((CharSequence)columnVo.getFormula())) {
                columnList = this.columnService.queryFormulaList(columnVo.getTableId());
                HashMap<String, String> propertyMap = new HashMap<String, String>();
                for (ColumnEntity columnEntity : columnList) {
                    propertyMap.put(columnEntity.getProperty(), columnEntity.getProperty());
                }
                Boolean checked = CalculatorUtils.checkFormula(columnVo.getFormula(), propertyMap);
                if (!checked.booleanValue()) {
                    return CommonResponse.error((String)"\u516c\u5f0f\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58");
                }
                String property = PinYinUtil.getFullSpell(columnVo.getColumnName());
                uniqueBean.setProperty(property);
            } else {
                uniqueBean.setProperty(columnVo.getProperty());
            }
            uniqueBean.setFormula(columnVo.getFormula());
            uniqueBean.setSearchFlag(columnVo.getSearchFlag());
            uniqueBean.setVisible(columnVo.getVisible());
            uniqueBean.setSequence(columnVo.getSequence());
            uniqueBean.setFormatter(columnVo.getFormatter());
            queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"table_id", (Object)uniqueBean.getTableId());
            queryWrapper.eq((Object)"property", (Object)uniqueBean.getProperty());
            queryWrapper.ne((Object)"id", (Object)columnVo.getId());
            List list = this.columnService.list((Wrapper)queryWrapper);
            if (list != null && list.size() > 0) {
                if (StringUtils.isNotBlank((CharSequence)uniqueBean.getFormula())) {
                    return CommonResponse.error((String)("\u5217\u540d:" + uniqueBean.getColumnName() + "\u5df2\u5b58\u5728"));
                }
                return CommonResponse.error((String)("\u5c5e\u6027:" + uniqueBean.getProperty() + "\u5df2\u5b58\u5728"));
            }
            this.columnService.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        ColumnEntity saveBean = (ColumnEntity)((Object)BeanMapper.map((Object)columnVo, ColumnEntity.class));
        if (StringUtils.isNotBlank((CharSequence)columnVo.getFormula())) {
            columnList = this.columnService.queryFormulaList(columnVo.getTableId());
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            for (ColumnEntity columnEntity : columnList) {
                propertyMap.put(columnEntity.getProperty(), columnEntity.getProperty());
            }
            Boolean checked = CalculatorUtils.checkFormula(columnVo.getFormula(), propertyMap);
            if (!checked.booleanValue()) {
                return CommonResponse.error((String)"\u516c\u5f0f\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58");
            }
            String property = PinYinUtil.getFullSpell(columnVo.getColumnName());
            saveBean.setProperty(property);
        } else {
            saveBean.setProperty(columnVo.getProperty());
        }
        if (columnVo.getSearchFlag() == null) {
            saveBean.setSearchFlag(0);
        }
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"table_id", (Object)saveBean.getTableId());
        queryWrapper.eq((Object)"property", (Object)saveBean.getProperty());
        List list = this.columnService.list((Wrapper)queryWrapper);
        if (list != null && list.size() > 0) {
            if (StringUtils.isNotBlank((CharSequence)saveBean.getFormula())) {
                return CommonResponse.error((String)("\u5217\u540d:" + saveBean.getColumnName() + "\u5df2\u5b58\u5728"));
            }
            return CommonResponse.error((String)("\u5c5e\u6027:" + saveBean.getProperty() + "\u5df2\u5b58\u5728"));
        }
        this.columnService.saveOrUpdate((Object)saveBean, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        IPage<ColumnEntity> pageData = this.columnService.queryPage(queryParam);
        List voList = BeanMapper.mapList((Iterable)pageData.getRecords(), Map.class);
        JSONObject resp = new JSONObject();
        resp.put("current", (Object)pageData.getCurrent());
        resp.put("size", (Object)pageData.getSize());
        resp.put("total", (Object)pageData.getTotal());
        resp.put("pages", (Object)pageData.getPages());
        List records = ResultAsTree.createTreeData((List)voList);
        resp.put("records", (Object)records);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)resp);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryFormulaList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryFormulaList(@RequestParam Long tableId) {
        List<ColumnEntity> columnList = this.columnService.queryFormulaList(tableId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", columnList);
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ColumnVO> queryDetail(@RequestParam Long id) {
        ColumnEntity columnEntity = (ColumnEntity)((Object)this.columnService.selectById(id));
        if (columnEntity != null) {
            ColumnVO columnVo = (ColumnVO)BeanMapper.map((Object)((Object)columnEntity), ColumnVO.class);
            return CommonResponse.success((Object)columnVo);
        }
        return null;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        this.columnService.deleteByIds(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/custom"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> customColumn(@RequestBody CustomColumnVO customColumnVo) {
        QueryWrapper customColumnWrapper = new QueryWrapper();
        customColumnWrapper.eq((Object)"column_id", (Object)customColumnVo.getColumnId());
        CustomColumnEntity customColumnEntity = (CustomColumnEntity)((Object)this.customColumnService.getOne((Wrapper)customColumnWrapper));
        if (customColumnEntity != null) {
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColumnName())) {
                customColumnEntity.setColumnName(customColumnVo.getColumnName());
            }
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getVisible())) {
                customColumnEntity.setVisible(customColumnVo.getVisible());
            }
            this.customColumnService.saveOrUpdate((Object)customColumnEntity, false);
        } else {
            CustomColumnEntity saveBean = new CustomColumnEntity();
            saveBean.setColumnId(customColumnVo.getColumnId());
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getColumnName())) {
                saveBean.setColumnName(customColumnVo.getColumnName());
            }
            if (StringUtils.isNotBlank((CharSequence)customColumnVo.getVisible())) {
                saveBean.setVisible(customColumnVo.getVisible());
            }
            this.customColumnService.saveOrUpdate((Object)saveBean, false);
        }
        return CommonResponse.success((String)"\u8bbe\u7f6e\u6210\u529f");
    }

    @RequestMapping(value={"/resetCustomColumn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> resetCustomColumn(@RequestParam Long tableId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.customColumnService.deleteByTenantId(tableId, tenantId);
        return CommonResponse.success((String)"\u6062\u590d\u6210\u529f");
    }
}

